"use strict";

/**
 * Module dependencies.
 */
const _require = require('string_decoder'),
      StringDecoder = _require.StringDecoder;

const Stream = require('stream');

const zlib = require('zlib');
/**
 * Buffers response data events and re-emits when they're unzipped.
 *
 * @param {Request} req
 * @param {Response} res
 * @api private
 */


exports.unzip = (request, res) => {
  const unzip = zlib.createUnzip();
  const stream = new Stream();
  let decoder; // make node responseOnEnd() happy

  stream.req = request;
  unzip.on('error', error => {
    if (error && error.code === 'Z_BUF_ERROR') {
      // unexpected end of file is ignored by browsers and curl
      stream.emit('end');
      return;
    }

    stream.emit('error', error);
  }); // pipe to unzip

  res.pipe(unzip); // override `setEncoding` to capture encoding

  res.setEncoding = type => {
    decoder = new StringDecoder(type);
  }; // decode upon decompressing with captured encoding


  unzip.on('data', buf => {
    if (decoder) {
      const string_ = decoder.write(buf);
      if (string_.length > 0) stream.emit('data', string_);
    } else {
      stream.emit('data', buf);
    }
  });
  unzip.on('end', () => {
    stream.emit('end');
  }); // override `on` to capture data listeners

  const _on = res.on;

  res.on = function (type, fn) {
    if (type === 'data' || type === 'end') {
      stream.on(type, fn.bind(res));
    } else if (type === 'error') {
      stream.on(type, fn.bind(res));

      _on.call(res, type, fn);
    } else {
      _on.call(res, type, fn);
    }

    return this;
  };
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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