"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const Stream = require('stream');

const util = require('util');

const net = require('net');

const tls = require('tls'); // eslint-disable-next-line node/no-deprecated-api


const _require = require('url'),
      parse = _require.parse;

const process = require('process');

const semverGte = require('semver/functions/gte');

let http2;
if (semverGte(process.version, 'v10.10.0')) http2 = require('http2');else throw new Error('superagent: this version of Node.js does not support http2');
const _http2$constants = http2.constants,
      HTTP2_HEADER_PATH = _http2$constants.HTTP2_HEADER_PATH,
      HTTP2_HEADER_STATUS = _http2$constants.HTTP2_HEADER_STATUS,
      HTTP2_HEADER_METHOD = _http2$constants.HTTP2_HEADER_METHOD,
      HTTP2_HEADER_AUTHORITY = _http2$constants.HTTP2_HEADER_AUTHORITY,
      HTTP2_HEADER_HOST = _http2$constants.HTTP2_HEADER_HOST,
      HTTP2_HEADER_SET_COOKIE = _http2$constants.HTTP2_HEADER_SET_COOKIE,
      NGHTTP2_CANCEL = _http2$constants.NGHTTP2_CANCEL;

function setProtocol(protocol) {
  return {
    request(options) {
      return new Request(protocol, options);
    }

  };
}

function Request(protocol, options) {
  Stream.call(this);
  const defaultPort = protocol === 'https:' ? 443 : 80;
  const defaultHost = 'localhost';
  const port = options.port || defaultPort;
  const host = options.host || defaultHost;
  delete options.port;
  delete options.host;
  this.method = options.method;
  this.path = options.path;
  this.protocol = protocol;
  this.host = host;
  delete options.method;
  delete options.path;

  const sessionOptions = _objectSpread({}, options);

  if (options.socketPath) {
    sessionOptions.socketPath = options.socketPath;
    sessionOptions.createConnection = this.createUnixConnection.bind(this);
  }

  this._headers = {};
  const session = http2.connect("".concat(protocol, "//").concat(host, ":").concat(port), sessionOptions);
  this.setHeader('host', "".concat(host, ":").concat(port));
  session.on('error', error => this.emit('error', error));
  this.session = session;
}
/**
 * Inherit from `Stream` (which inherits from `EventEmitter`).
 */


util.inherits(Request, Stream);

Request.prototype.createUnixConnection = function (authority, options) {
  switch (this.protocol) {
    case 'http:':
      return net.connect(options.socketPath);

    case 'https:':
      options.ALPNProtocols = ['h2'];
      options.servername = this.host;
      options.allowHalfOpen = true;
      return tls.connect(options.socketPath, options);

    default:
      throw new Error('Unsupported protocol', this.protocol);
  }
}; // eslint-disable-next-line no-unused-vars


Request.prototype.setNoDelay = function (bool) {// We can not use setNoDelay with HTTP/2.
  // Node 10 limits http2session.socket methods to ones safe to use with HTTP/2.
  // See also https://nodejs.org/api/http2.html#http2_http2session_socket
};

Request.prototype.getFrame = function () {
  if (this.frame) {
    return this.frame;
  }

  const method = {
    [HTTP2_HEADER_PATH]: this.path,
    [HTTP2_HEADER_METHOD]: this.method
  };
  let headers = this.mapToHttp2Header(this._headers);
  headers = Object.assign(headers, method);
  const frame = this.session.request(headers); // eslint-disable-next-line no-unused-vars

  frame.once('response', (headers, flags) => {
    headers = this.mapToHttpHeader(headers);
    frame.headers = headers;
    frame.statusCode = headers[HTTP2_HEADER_STATUS];
    frame.status = frame.statusCode;
    this.emit('response', frame);
  });
  this._headerSent = true;
  frame.once('drain', () => this.emit('drain'));
  frame.on('error', error => this.emit('error', error));
  frame.on('close', () => this.session.close());
  this.frame = frame;
  return frame;
};

Request.prototype.mapToHttpHeader = function (headers) {
  const keys = Object.keys(headers);
  const http2Headers = {};

  for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
    let key = _keys[_i];
    let value = headers[key];
    key = key.toLowerCase();

    switch (key) {
      case HTTP2_HEADER_SET_COOKIE:
        value = Array.isArray(value) ? value : [value];
        break;

      default:
        break;
    }

    http2Headers[key] = value;
  }

  return http2Headers;
};

Request.prototype.mapToHttp2Header = function (headers) {
  const keys = Object.keys(headers);
  const http2Headers = {};

  for (var _i2 = 0, _keys2 = keys; _i2 < _keys2.length; _i2++) {
    let key = _keys2[_i2];
    let value = headers[key];
    key = key.toLowerCase();

    switch (key) {
      case HTTP2_HEADER_HOST:
        key = HTTP2_HEADER_AUTHORITY;
        value = /^http:\/\/|^https:\/\//.test(value) ? parse(value).host : value;
        break;

      default:
        break;
    }

    http2Headers[key] = value;
  }

  return http2Headers;
};

Request.prototype.setHeader = function (name, value) {
  this._headers[name.toLowerCase()] = value;
};

Request.prototype.getHeader = function (name) {
  return this._headers[name.toLowerCase()];
};

Request.prototype.write = function (data, encoding) {
  const frame = this.getFrame();
  return frame.write(data, encoding);
};

Request.prototype.pipe = function (stream, options) {
  const frame = this.getFrame();
  return frame.pipe(stream, options);
};

Request.prototype.end = function (data) {
  const frame = this.getFrame();
  frame.end(data);
}; // eslint-disable-next-line no-unused-vars


Request.prototype.abort = function (data) {
  const frame = this.getFrame();
  frame.close(NGHTTP2_CANCEL);
  this.session.destroy();
};

exports.setProtocol = setProtocol;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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