var bindings = require('./bindings');

/// create a new element on the given document
/// @param doc the Document to create the element for
/// @param name the element name
/// @param {String} [contenn] element content
/// @constructor
function Element(doc, name, content) {
    if (!doc) {
        throw new Error('document argument required');
    } else if (! (doc instanceof bindings.Document)) {
        throw new Error('document argument must be an ' +
                        'instance of Document');
    } else if (!name) {
        throw new Error('name argument required');
    }

    return new bindings.Element(doc, name, content);
}

Element.prototype = bindings.Element.prototype;

Element.prototype.attr = function() {
    if (arguments.length === 1) {
        var arg = arguments[0];
        if (typeof arg === 'object') {
            // object setter
            // iterate keys/value to set attributes
            for (var k in arg) {
                this._attr(k, arg[k]);
            };
            return this;
        } else if (typeof arg === 'string') {
            // getter
            return this._attr(arg);
        }
    } else if (arguments.length === 2) {
        // 2 arg setter
        var name = arguments[0];
        var value = arguments[1];
        this._attr(name, value);
        return this;
    }
};

/// helper method to attach a new node to this element
/// @param name the element name
/// @param {String} [content] element content
Element.prototype.node = function(name, content) {
    var elem = Element(this.doc(), name, content);
    this.addChild(elem);
    return elem;
};

/// helper method to attach a cdata to this element
/// @param name the element name
/// @param {String} [content] element content
Element.prototype.cdata = function(content) {
  this.addCData(content);
  return this;
};

Element.prototype.get = function() {
    var res = this.find.apply(this, arguments);
    if (res instanceof Array) {
        return res[0];
    } else {
        return res;
    }
};

Element.prototype.defineNamespace = function(prefix, href) {
    // if no prefix specified
    if (!href) {
        href = prefix;
        prefix = null;
    }
    return new bindings.Namespace(this, prefix, href);
};

module.exports = Element;

