/// <reference types="node" />
import { Stats } from 'fs';
import { Readable } from 'stream';
import { FileType } from '../enum';
/**
 * read file type
 * @param stats
 */
export declare function getType(stats: Stats): FileType;
/**
 * get file mimetype by content
 * @param path
 * @param content
 */
export declare function guessMimeType(path: string, content?: Buffer): Promise<string | undefined>;
/**
 *
 * @param stats
 * @param {number} mask 1、execute; 4、read; 2、write
 */
export declare function fileHasPermission(stats: Stats, mask: number): boolean;
/**
 * js check variable is stream
 * @param stream
 */
export declare function isReadableStream(stream: Readable): false | "string" | "number" | "bigint" | "boolean" | "symbol" | "undefined" | "object" | "function";
/**
 * string chunk by length
 * @param {string} str
 * @param {number} length
 * @return {string[]}
 */
export declare function stringChunk(str: string, length?: number): string[];
/**
 * parse date from format
 * @param input
 * @param format
 */
export declare function createDateFromFormat(input: string, format?: string): Date;
/**
 * check var is numeric
 */
export declare function isNumeric(mixedVar: string | null | any): boolean;
