/*!
 * @filesystem/core v0.0.3-alpha.5
 * (c) 2021 LiuYang
 * @license MIT
 */
import fs,{chmod as chmod$1,access as access$1,lstat as lstat$1,mkdir as mkdir$1,readdir as readdir$1,rmdir as rmdir$1,stat as stat$1,unlink as unlink$1,copyFile as copyFile$1,readFile as readFile$1,writeFile as writeFile$1,rename as rename$1,realpath as realpath$1,symlink as symlink$1,constants,statSync,mkdirSync,createWriteStream,createReadStream}from"fs";import assert from"assert";import{extname,dirname,join,sep}from"path";import{Stream}from"stream";import{promisify}from"util";
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */var extendStatics=function(e,t){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])})(e,t)};function __extends(e,t){function i(){this.constructor=e}extendStatics(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}function __awaiter(e,t,i,a){return new(i||(i=Promise))((function(n,r){function o(e){try{p(a.next(e))}catch(e){r(e)}}function s(e){try{p(a.throw(e))}catch(e){r(e)}}function p(e){var t;e.done?n(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(o,s)}p((a=a.apply(e,t||[])).next())}))}function __generator(e,t){var i,a,n,r,o={label:0,sent:function(){if(1&n[0])throw n[1];return n[1]},trys:[],ops:[]};return r={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(r[Symbol.iterator]=function(){return this}),r;function s(r){return function(s){return function(r){if(i)throw new TypeError("Generator is already executing.");for(;o;)try{if(i=1,a&&(n=2&r[0]?a.return:r[0]?a.throw||((n=a.return)&&n.call(a),0):a.next)&&!(n=n.call(a,r[1])).done)return n;switch(a=0,n&&(r=[2&r[0],n.value]),r[0]){case 0:case 1:n=r;break;case 4:return o.label++,{value:r[1],done:!1};case 5:o.label++,a=r[1],r=[0];continue;case 7:r=o.ops.pop(),o.trys.pop();continue;default:if(!(n=o.trys,(n=n.length>0&&n[n.length-1])||6!==r[0]&&2!==r[0])){o=0;continue}if(3===r[0]&&(!n||r[1]>n[0]&&r[1]<n[3])){o.label=r[1];break}if(6===r[0]&&o.label<n[1]){o.label=n[1],n=r;break}if(n&&o.label<n[2]){o.label=n[2],o.ops.push(r);break}n[2]&&o.ops.pop(),o.trys.pop();continue}r=t.call(e,o)}catch(e){r=[6,e],a=0}finally{i=n=0}if(5&r[0])throw r[1];return{value:r[0]?r[1]:void 0,done:!0}}([r,s])}}}var commonjsGlobal="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function createCommonjsModule(e,t,i){return e(i={path:t,exports:{},require:function(e,t){return commonjsRequire(e,null==t?i.path:t)}},i.exports),i.exports}function commonjsRequire(){throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs")}var FsPromise=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.readFile=t.writeFileSync=t.writeFile=t.read=t.open=t.close=t.stat=t.createReadStream=t.pathExists=void 0,t.pathExists=fs.existsSync,t.createReadStream=fs.createReadStream,t.stat=async function(e){return new Promise(((t,i)=>{fs.stat(e,((e,a)=>{e?i(e):t(a)}))}))},t.close=async function(e){return new Promise(((t,i)=>{fs.close(e,(e=>{e?i(e):t()}))}))},t.open=async function(e,t){return new Promise(((i,a)=>{fs.open(e,t,((e,t)=>{e?a(e):i(t)}))}))},t.read=async function(e,t,i,a,n){return new Promise(((r,o)=>{fs.read(e,t,i,a,n,((e,t,i)=>{e?o(e):r({bytesRead:t,buffer:i})}))}))},t.writeFile=async function(e,t){return new Promise(((i,a)=>{fs.writeFile(e,t,(e=>{e?a(e):i()}))}))},t.writeFileSync=function(e,t){fs.writeFileSync(e,t)},t.readFile=async function(e){return new Promise(((t,i)=>{fs.readFile(e,((e,a)=>{e?i(e):t(a)}))}))}})),EndOfFileStream=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.defaultMessages="End-Of-Stream";class i extends Error{constructor(){super(t.defaultMessages)}}t.EndOfStreamError=i})),lib=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0});var i=EndOfFileStream;t.EndOfStreamError=i.EndOfStreamError;class a{constructor(){this.promise=new Promise(((e,t)=>{this.reject=t,this.resolve=e}))}}t.StreamReader=class{constructor(e){if(this.s=e,this.endOfStream=!1,this.peekQueue=[],!e.read||!e.once)throw new Error("Expected an instance of stream.Readable");this.s.once("end",(()=>this.reject(new EndOfFileStream.EndOfStreamError))),this.s.once("error",(e=>this.reject(e))),this.s.once("close",(()=>this.reject(new Error("Stream closed"))))}async peek(e,t,i){const a=await this.read(e,t,i);return this.peekQueue.push(e.slice(t,t+a)),a}async read(e,t,i){if(0===i)return 0;if(0===this.peekQueue.length&&this.endOfStream)throw new EndOfFileStream.EndOfStreamError;let a=i,n=0;for(;this.peekQueue.length>0&&a>0;){const i=this.peekQueue.pop(),r=Math.min(i.length,a);i.copy(e,t+n,0,r),n+=r,a-=r,r<i.length&&this.peekQueue.push(i.slice(r))}for(;a>0&&!this.endOfStream;){const i=Math.min(a,1048576),r=await this._read(e,t+n,i);if(n+=r,r<i)break;a-=r}return n}async _read(e,t,i){assert.ok(!this.request,"Concurrent read operation?");const n=this.s.read(i);return n?(n.copy(e,t),n.length):(this.request={buffer:e,offset:t,length:i,deferred:new a},this.s.once("readable",(()=>{this.tryRead()})),this.request.deferred.promise.then((e=>(this.request=null,e)),(e=>{throw this.request=null,e})))}tryRead(){const e=this.s.read(this.request.length);e?(e.copy(this.request.buffer,this.request.offset),this.request.deferred.resolve(e.length)):this.s.once("readable",(()=>{this.tryRead()}))}reject(e){this.endOfStream=!0,this.request&&(this.request.deferred.reject(e),this.request=null)}}})),AbstractTokenizer_1=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.AbstractTokenizer=void 0;t.AbstractTokenizer=class{constructor(e){this.position=0,this.numBuffer=Buffer.alloc(10),this.fileInfo=e||{}}async readToken(e,t){const i=Buffer.alloc(e.len);if(await this.readBuffer(i,{position:t})<e.len)throw new lib.EndOfStreamError;return e.get(i,0)}async peekToken(e,t=this.position){const i=Buffer.alloc(e.len);if(await this.peekBuffer(i,{position:t})<e.len)throw new lib.EndOfStreamError;return e.get(i,0)}async readNumber(e){if(await this.readBuffer(this.numBuffer,{length:e.len})<e.len)throw new lib.EndOfStreamError;return e.get(this.numBuffer,0)}async peekNumber(e){if(await this.peekBuffer(this.numBuffer,{length:e.len})<e.len)throw new lib.EndOfStreamError;return e.get(this.numBuffer,0)}async close(){}}})),ReadStreamTokenizer_1=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.ReadStreamTokenizer=void 0;class i extends AbstractTokenizer_1.AbstractTokenizer{constructor(e,t){super(t),this.streamReader=new lib.StreamReader(e)}async getFileInfo(){return this.fileInfo}async readBuffer(e,t){let i=0,a=e.length;if(t){if(Number.isInteger(t.length)?a=t.length:a-=t.offset||0,t.position){const i=t.position-this.position;if(i>0)return await this.ignore(i),this.readBuffer(e,t);if(i<0)throw new Error("`options.position` must be equal or greater than `tokenizer.position`")}t.offset&&(i=t.offset)}if(0===a)return 0;const n=await this.streamReader.read(e,i,a);if(this.position+=n,(!t||!t.mayBeLess)&&n<a)throw new lib.EndOfStreamError;return n}async peekBuffer(e,t){let i,a=0,n=e.length;if(t&&(t.offset&&(a=t.offset),Number.isInteger(t.length)?n=t.length:n-=t.offset||0,t.position)){const r=t.position-this.position;if(r>0){const o=Buffer.alloc(n+r);return i=await this.peekBuffer(o,{mayBeLess:t.mayBeLess}),o.copy(e,a,r),i-r}if(r<0)throw new Error("Cannot peek from a negative offset in a stream")}try{i=await this.streamReader.peek(e,a,n)}catch(e){if(t&&t.mayBeLess&&e instanceof lib.EndOfStreamError)return 0;throw e}if((!t||!t.mayBeLess)&&i<n)throw new lib.EndOfStreamError;return i}async ignore(e){const t=Math.min(256e3,e),i=Buffer.alloc(t);let a=0;for(;a<e;){const n=e-a,r=await this.readBuffer(i,{length:Math.min(t,n)});if(r<0)return r;a+=r}return a}}t.ReadStreamTokenizer=i})),BufferTokenizer_1=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.BufferTokenizer=void 0;t.BufferTokenizer=class{constructor(e,t){this.buffer=e,this.position=0,this.fileInfo=t||{},this.fileInfo.size=this.fileInfo.size?this.fileInfo.size:e.length}async readBuffer(e,t){if(t&&t.position){if(t.position<this.position)throw new Error("`options.position` must be equal or greater than `tokenizer.position`");this.position=t.position}return this.peekBuffer(e,t).then((e=>(this.position+=e,e)))}async peekBuffer(e,t){let i=0,a=e.length,n=this.position;if(t){if(t.position){if(t.position<this.position)throw new Error("`options.position` can be less than `tokenizer.position`");n=t.position}Number.isInteger(t.length)?a=t.length:a-=t.offset||0,t.offset&&(i=t.offset)}if(0===a)return Promise.resolve(0);n=n||this.position,a||(a=e.length);const r=Math.min(this.buffer.length-n,a);if(t&&t.mayBeLess||!(r<a))return this.buffer.copy(e,i,n,n+r),r;throw new lib.EndOfStreamError}async readToken(e,t){this.position=t||this.position;try{const t=this.peekToken(e,this.position);return this.position+=e.len,t}catch(e){throw this.position+=this.buffer.length-t,e}}async peekToken(e,t=this.position){if(this.buffer.length-t<e.len)throw new lib.EndOfStreamError;return e.get(this.buffer,t)}async readNumber(e){return this.readToken(e)}async peekNumber(e){return this.peekToken(e)}async ignore(e){const t=Math.min(this.buffer.length-this.position,e);return this.position+=t,t}async close(){}}})),core=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.fromBuffer=t.fromStream=void 0,Object.defineProperty(t,"EndOfStreamError",{enumerable:!0,get:function(){return lib.EndOfStreamError}}),t.fromStream=function(e,t){return t=t||{},new ReadStreamTokenizer_1.ReadStreamTokenizer(e,t)},t.fromBuffer=function(e,t){return new BufferTokenizer_1.BufferTokenizer(e,t)}})),FileTokenizer_1=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.fromFile=t.FileTokenizer=void 0;class i extends AbstractTokenizer_1.AbstractTokenizer{constructor(e,t){super(t),this.fd=e}async readBuffer(e,t){let i=0,a=e.length;if(t){if(t.position){if(t.position<this.position)throw new Error("`options.position` must be equal or greater than `tokenizer.position`");this.position=t.position}Number.isInteger(t.length)?a=t.length:a-=t.offset||0,t.offset&&(i=t.offset)}if(0===a)return Promise.resolve(0);const n=await FsPromise.read(this.fd,e,i,a,this.position);if(this.position+=n.bytesRead,n.bytesRead<a&&(!t||!t.mayBeLess))throw new lib.EndOfStreamError;return n.bytesRead}async peekBuffer(e,t){let i=0,a=e.length,n=this.position;if(t){if(t.position){if(t.position<this.position)throw new Error("`options.position` must be equal or greater than `tokenizer.position`");n=t.position}Number.isInteger(t.length)?a=t.length:a-=t.offset||0,t.offset&&(i=t.offset)}if(0===a)return Promise.resolve(0);const r=await FsPromise.read(this.fd,e,i,a,n);if((!t||!t.mayBeLess)&&r.bytesRead<a)throw new lib.EndOfStreamError;return r.bytesRead}async ignore(e){const t=this.fileInfo.size-this.position;return e<=t?(this.position+=e,e):(this.position+=t,t)}async close(){return FsPromise.close(this.fd)}}t.FileTokenizer=i,t.fromFile=async function(e){const t=await FsPromise.stat(e);if(!t.isFile)throw new Error("File not a file: "+e);const a=await FsPromise.open(e,"r");return new i(a,{path:e,size:t.size})}})),lib$1=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.fromStream=void 0,Object.defineProperty(t,"fromFile",{enumerable:!0,get:function(){return FileTokenizer_1.fromFile}});var i=core;Object.defineProperty(t,"EndOfStreamError",{enumerable:!0,get:function(){return i.EndOfStreamError}}),Object.defineProperty(t,"fromBuffer",{enumerable:!0,get:function(){return i.fromBuffer}}),t.fromStream=async function(e,t){if(t=t||{},e.path){const i=await FsPromise.stat(e.path);t.path=e.path,t.size=i.size}return core.fromStream(e,t)}})),read=function(e,t,i,a,n){var r,o,s=8*n-a-1,p=(1<<s)-1,c=p>>1,l=-7,m=i?n-1:0,d=i?-1:1,u=e[t+m];for(m+=d,r=u&(1<<-l)-1,u>>=-l,l+=s;l>0;r=256*r+e[t+m],m+=d,l-=8);for(o=r&(1<<-l)-1,r>>=-l,l+=a;l>0;o=256*o+e[t+m],m+=d,l-=8);if(0===r)r=1-c;else{if(r===p)return o?NaN:1/0*(u?-1:1);o+=Math.pow(2,a),r-=c}return(u?-1:1)*o*Math.pow(2,r-a)},write=function(e,t,i,a,n,r){var o,s,p,c=8*r-n-1,l=(1<<c)-1,m=l>>1,d=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,u=a?0:r-1,f=a?1:-1,v=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,o=l):(o=Math.floor(Math.log(t)/Math.LN2),t*(p=Math.pow(2,-o))<1&&(o--,p*=2),(t+=o+m>=1?d/p:d*Math.pow(2,1-m))*p>=2&&(o++,p/=2),o+m>=l?(s=0,o=l):o+m>=1?(s=(t*p-1)*Math.pow(2,n),o+=m):(s=t*Math.pow(2,m-1)*Math.pow(2,n),o=0));n>=8;e[i+u]=255&s,u+=f,s/=256,n-=8);for(o=o<<n|s,c+=n;c>0;e[i+u]=255&o,u+=f,o/=256,c-=8);e[i+u-f]|=128*v},ieee754={read:read,write:write},lib$2=createCommonjsModule((function(e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.UINT8={len:1,get:(e,t)=>e.readUInt8(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=255),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUInt8(i,t)}},t.UINT16_LE={len:2,get:(e,t)=>e.readUInt16LE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=65535),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUInt16LE(i,t)}},t.UINT16_BE={len:2,get:(e,t)=>e.readUInt16BE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=65535),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUInt16BE(i,t)}},t.UINT24_LE={len:3,get:(e,t)=>e.readUIntLE(t,3),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=16777215),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUIntLE(i,t,3)}},t.UINT24_BE={len:3,get:(e,t)=>e.readUIntBE(t,3),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=16777215),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUIntBE(i,t,3)}},t.UINT32_LE={len:4,get:(e,t)=>e.readUInt32LE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=4294967295),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUInt32LE(i,t)}},t.UINT32_BE={len:4,get:(e,t)=>e.readUInt32BE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=0&&i<=4294967295),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeUInt32BE(i,t)}},t.INT8={len:1,get:(e,t)=>e.readInt8(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-128&&i<=127),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeInt8(i,t)}},t.INT16_BE={len:2,get:(e,t)=>e.readInt16BE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-32768&&i<=32767),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeInt16BE(i,t)}},t.INT16_LE={len:2,get:(e,t)=>e.readInt16LE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-32768&&i<=32767),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeInt16LE(i,t)}},t.INT24_LE={len:3,get:(e,t)=>e.readIntLE(t,3),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-8388608&&i<=8388607),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeIntLE(i,t,3)}},t.INT24_BE={len:3,get:(e,t)=>e.readIntBE(t,3),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-8388608&&i<=8388607),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeIntBE(i,t,3)}},t.INT32_BE={len:4,get:(e,t)=>e.readInt32BE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-2147483648&&i<=2147483647),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeInt32BE(i,t)}},t.INT32_LE={len:4,get:(e,t)=>e.readInt32LE(t),put(e,t,i){return assert.equal(typeof t,"number"),assert.equal(typeof i,"number"),assert.ok(i>=-2147483648&&i<=2147483647),assert.ok(t>=0),assert.ok(this.len<=e.length),e.writeInt32LE(i,t)}},t.UINT64_LE={len:8,get(e,t){return function(e,t,i){i>>>=0;let a=e[t>>>=0],n=1,r=0;for(;++r<i&&(n*=256);)a+=e[t+r]*n;return a}(e,t,this.len)},put(e,t,i){return function(e,t,i,a){t=+t,a>>>=0;let n=1,r=0;e[i>>>=0]=255&t;for(;++r<a&&(n*=256);)e[i+r]=t/n&255;return i+a}(e,i,t,this.len)}},t.INT64_LE={len:8,get(e,t){return function(e,t,i){i>>>=0;let a=e[t>>>=0],n=1,r=0;for(;++r<i&&(n*=256);)a+=e[t+r]*n;n*=128,a>=n&&(a-=Math.pow(2,8*i));return a}(e,t,this.len)},put(e,t,i){return a(e,i,t,this.len)}},t.UINT64_BE={len:8,get(e,t){return n(e,t,this.len)},put(e,t,i){return r(e,i,t,this.len)}},t.INT64_BE={len:8,get(e,t){return o(e,t,this.len)},put(e,t,i){return s(e,i,t,this.len)}},t.Float16_BE={len:2,get(e,t){return ieee754.read(e,t,!1,10,this.len)},put(e,t,i){return ieee754.write(e,i,t,!1,10,this.len)}},t.Float16_LE={len:2,get(e,t){return ieee754.read(e,t,!0,10,this.len)},put(e,t,i){return ieee754.write(e,i,t,!0,10,this.len)}},t.Float32_BE={len:4,get:(e,t)=>e.readFloatBE(t),put:(e,t,i)=>e.writeFloatBE(i,t)},t.Float32_LE={len:4,get:(e,t)=>e.readFloatLE(t),put:(e,t,i)=>e.writeFloatLE(i,t)},t.Float64_BE={len:8,get:(e,t)=>e.readDoubleBE(t),put:(e,t,i)=>e.writeDoubleBE(i,t)},t.Float64_LE={len:8,get:(e,t)=>e.readDoubleLE(t),put:(e,t,i)=>e.writeDoubleLE(i,t)},t.Float80_BE={len:10,get(e,t){return ieee754.read(e,t,!1,63,this.len)},put(e,t,i){return ieee754.write(e,i,t,!1,63,this.len)}},t.Float80_LE={len:10,get(e,t){return ieee754.read(e,t,!0,63,this.len)},put(e,t,i){return ieee754.write(e,i,t,!0,63,this.len)}};t.IgnoreType=class{constructor(e){this.len=e}get(e,t){}};t.BufferType=class{constructor(e){this.len=e}get(e,t){return e.slice(t,t+this.len)}};t.StringType=class{constructor(e,t){this.len=e,this.encoding=t}get(e,t){return e.toString(this.encoding,t,t+this.len)}};class i{constructor(e){this.len=e}static decode(e,t,a){let n="";for(let r=t;r<a;++r)n+=i.codePointToString(i.singleByteDecoder(e[r]));return n}static inRange(e,t,i){return t<=e&&e<=i}static codePointToString(e){return e<=65535?String.fromCharCode(e):(e-=65536,String.fromCharCode(55296+(e>>10),56320+(1023&e)))}static singleByteDecoder(e){if(i.inRange(e,0,127))return e;const t=i.windows1252[e-128];if(null===t)throw Error("invaliding encoding");return t}get(e,t=0){return i.decode(e,t,t+this.len)}}function a(e,t,i,a){t=+t;let n=0,r=1,o=0;for(e[i>>>=0]=255&t;++n<a&&(r*=256);)t<0&&0===o&&0!==e[i+n-1]&&(o=1),e[i+n]=(t/r>>0)-o&255;return i+a}function n(e,t,i){i>>>=0;let a=e[(t>>>=0)+--i],n=1;for(;i>0&&(n*=256);)a+=e[t+--i]*n;return a}function r(e,t,i,a){t=+t;let n=(a>>>=0)-1,r=1;for(e[(i>>>=0)+n]=255&t;--n>=0&&(r*=256);)e[i+n]=t/r&255;return i+a}function o(e,t,i){let a=i>>>=0,n=1,r=e[(t>>>=0)+--a];for(;a>0&&(n*=256);)r+=e[t+--a]*n;return n*=128,r>=n&&(r-=Math.pow(2,8*i)),r}function s(e,t,i,a){t=+t;let n=a-1,r=1,o=0;for(e[(i>>>=0)+n]=255&t;--n>=0&&(r*=256);)t<0&&0===o&&0!==e[i+n+1]&&(o=1),e[i+n]=(t/r>>0)-o&255;return i+a}t.AnsiStringType=i,i.windows1252=[8364,129,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,141,381,143,144,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,157,382,376,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255],t.writeIntLE=a,t.readUIntBE=n,t.writeUIntBE=r,t.readIntBE=o,t.writeIntBE=s})),stringToBytes=e=>[...e].map((e=>e.charCodeAt(0))),tarHeaderChecksumMatches=e=>{if(e.length<512)return!1;const t=parseInt(e.toString("utf8",148,154).replace(/\0.*$/,"").trim(),8);if(isNaN(t))return!1;let i=256,a=0;for(let t=0;t<148;t++){const n=e[t];i+=n,a+=128&n}for(let t=156;t<512;t++){const n=e[t];i+=n,a+=128&n}return t===i||t===i-(a<<1)},uint32SyncSafeToken={get:(e,t)=>127&e[t+3]|e[t+2]<<7|e[t+1]<<14|e[t]<<21,len:4},util={stringToBytes:stringToBytes,tarHeaderChecksumMatches:tarHeaderChecksumMatches,uint32SyncSafeToken:uint32SyncSafeToken},supported={extensions:["jpg","png","apng","gif","webp","flif","cr2","cr3","orf","arw","dng","nef","rw2","raf","tif","bmp","icns","jxr","psd","indd","zip","tar","rar","gz","bz2","7z","dmg","mp4","mid","mkv","webm","mov","avi","mpg","mp2","mp3","m4a","oga","ogg","ogv","opus","flac","wav","spx","amr","pdf","epub","exe","swf","rtf","wasm","woff","woff2","eot","ttf","otf","ico","flv","ps","xz","sqlite","nes","crx","xpi","cab","deb","ar","rpm","Z","lz","msi","mxf","mts","blend","bpg","docx","pptx","xlsx","3gp","3g2","jp2","jpm","jpx","mj2","aif","qcp","odt","ods","odp","xml","mobi","heic","cur","ktx","ape","wv","wmv","wma","dcm","ics","glb","pcap","dsf","lnk","alias","voc","ac3","m4v","m4p","m4b","f4v","f4p","f4b","f4a","mie","asf","ogm","ogx","mpc","arrow","shp","aac","mp1","it","s3m","xm","ai","skp","avif","eps","lzh","pgp","asar"],mimeTypes:["image/jpeg","image/png","image/gif","image/webp","image/flif","image/x-canon-cr2","image/x-canon-cr3","image/tiff","image/bmp","image/vnd.ms-photo","image/vnd.adobe.photoshop","application/x-indesign","application/epub+zip","application/x-xpinstall","application/vnd.oasis.opendocument.text","application/vnd.oasis.opendocument.spreadsheet","application/vnd.oasis.opendocument.presentation","application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.openxmlformats-officedocument.presentationml.presentation","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet","application/zip","application/x-tar","application/x-rar-compressed","application/gzip","application/x-bzip2","application/x-7z-compressed","application/x-apple-diskimage","application/x-apache-arrow","video/mp4","audio/midi","video/x-matroska","video/webm","video/quicktime","video/vnd.avi","audio/vnd.wave","audio/qcelp","audio/x-ms-wma","video/x-ms-asf","application/vnd.ms-asf","video/mpeg","video/3gpp","audio/mpeg","audio/mp4","audio/opus","video/ogg","audio/ogg","application/ogg","audio/x-flac","audio/ape","audio/wavpack","audio/amr","application/pdf","application/x-msdownload","application/x-shockwave-flash","application/rtf","application/wasm","font/woff","font/woff2","application/vnd.ms-fontobject","font/ttf","font/otf","image/x-icon","video/x-flv","application/postscript","application/eps","application/x-xz","application/x-sqlite3","application/x-nintendo-nes-rom","application/x-google-chrome-extension","application/vnd.ms-cab-compressed","application/x-deb","application/x-unix-archive","application/x-rpm","application/x-compress","application/x-lzip","application/x-msi","application/x-mie","application/mxf","video/mp2t","application/x-blender","image/bpg","image/jp2","image/jpx","image/jpm","image/mj2","audio/aiff","application/xml","application/x-mobipocket-ebook","image/heif","image/heif-sequence","image/heic","image/heic-sequence","image/icns","image/ktx","application/dicom","audio/x-musepack","text/calendar","model/gltf-binary","application/vnd.tcpdump.pcap","audio/x-dsf","application/x.ms.shortcut","application/x.apple.alias","audio/x-voc","audio/vnd.dolby.dd-raw","audio/x-m4a","image/apng","image/x-olympus-orf","image/x-sony-arw","image/x-adobe-dng","image/x-nikon-nef","image/x-panasonic-rw2","image/x-fujifilm-raf","video/x-m4v","video/3gpp2","application/x-esri-shape","audio/aac","audio/x-it","audio/x-s3m","audio/x-xm","video/MP1S","video/MP2P","application/vnd.sketchup.skp","image/avif","application/x-lzh-compressed","application/pgp-encrypted","application/x-asar"]};const{stringToBytes:stringToBytes$1,tarHeaderChecksumMatches:tarHeaderChecksumMatches$1,uint32SyncSafeToken:uint32SyncSafeToken$1}=util,minimumBytes=4100;async function fromStream(e){const t=await core.fromStream(e);try{return await fromTokenizer(t)}finally{await t.close()}}async function fromBuffer(e){if(!(e instanceof Uint8Array||e instanceof ArrayBuffer||Buffer.isBuffer(e)))throw new TypeError(`Expected the \`input\` argument to be of type \`Uint8Array\` or \`Buffer\` or \`ArrayBuffer\`, got \`${typeof e}\``);const t=e instanceof Buffer?e:Buffer.from(e);if(!(t&&t.length>1))return;return fromTokenizer(core.fromBuffer(t))}function _check(e,t,i){i={offset:0,...i};for(const[a,n]of t.entries())if(i.mask){if(n!==(i.mask[a]&e[a+i.offset]))return!1}else if(n!==e[a+i.offset])return!1;return!0}async function _checkSequence(e,t,i){const a=Buffer.alloc(minimumBytes);return await t.ignore(i),await t.peekBuffer(a,{mayBeLess:!0}),a.includes(Buffer.from(e))}async function fromTokenizer(e){try{return _fromTokenizer(e)}catch(e){if(!(e instanceof core.EndOfStreamError))throw e}}async function _fromTokenizer(e){let t=Buffer.alloc(minimumBytes);const i=(e,i)=>_check(t,e,i),a=(e,t)=>i(stringToBytes$1(e),t);if(e.fileInfo.size||(e.fileInfo.size=Number.MAX_SAFE_INTEGER),await e.peekBuffer(t,{length:12,mayBeLess:!0}),i([66,77]))return{ext:"bmp",mime:"image/bmp"};if(i([11,119]))return{ext:"ac3",mime:"audio/vnd.dolby.dd-raw"};if(i([120,1]))return{ext:"dmg",mime:"application/x-apple-diskimage"};if(i([77,90]))return{ext:"exe",mime:"application/x-msdownload"};if(i([37,33]))return await e.peekBuffer(t,{length:24,mayBeLess:!0}),a("PS-Adobe-",{offset:2})&&a(" EPSF-",{offset:14})?{ext:"eps",mime:"application/eps"}:{ext:"ps",mime:"application/postscript"};if(i([31,160])||i([31,157]))return{ext:"Z",mime:"application/x-compress"};if(i([255,216,255]))return{ext:"jpg",mime:"image/jpeg"};if(i([73,73,188]))return{ext:"jxr",mime:"image/vnd.ms-photo"};if(i([31,139,8]))return{ext:"gz",mime:"application/gzip"};if(i([66,90,104]))return{ext:"bz2",mime:"application/x-bzip2"};if(a("ID3")){await e.ignore(6);const t=await e.readToken(uint32SyncSafeToken$1);return e.position+t>e.fileInfo.size?{ext:"mp3",mime:"audio/mpeg"}:(await e.ignore(t),fromTokenizer(e))}if(a("MP+"))return{ext:"mpc",mime:"audio/x-musepack"};if((67===t[0]||70===t[0])&&i([87,83],{offset:1}))return{ext:"swf",mime:"application/x-shockwave-flash"};if(i([71,73,70]))return{ext:"gif",mime:"image/gif"};if(a("FLIF"))return{ext:"flif",mime:"image/flif"};if(a("8BPS"))return{ext:"psd",mime:"image/vnd.adobe.photoshop"};if(a("WEBP",{offset:8}))return{ext:"webp",mime:"image/webp"};if(a("MPCK"))return{ext:"mpc",mime:"audio/x-musepack"};if(a("FORM"))return{ext:"aif",mime:"audio/aiff"};if(a("icns",{offset:0}))return{ext:"icns",mime:"image/icns"};if(i([80,75,3,4])){try{for(;e.position+30<e.fileInfo.size;){await e.readBuffer(t,{length:30});const i={compressedSize:t.readUInt32LE(18),uncompressedSize:t.readUInt32LE(22),filenameLength:t.readUInt16LE(26),extraFieldLength:t.readUInt16LE(28)};if(i.filename=await e.readToken(new lib$2.StringType(i.filenameLength,"utf-8")),await e.ignore(i.extraFieldLength),"META-INF/mozilla.rsa"===i.filename)return{ext:"xpi",mime:"application/x-xpinstall"};if(i.filename.endsWith(".rels")||i.filename.endsWith(".xml")){switch(i.filename.split("/")[0]){case"_rels":break;case"word":return{ext:"docx",mime:"application/vnd.openxmlformats-officedocument.wordprocessingml.document"};case"ppt":return{ext:"pptx",mime:"application/vnd.openxmlformats-officedocument.presentationml.presentation"};case"xl":return{ext:"xlsx",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}}}if(i.filename.startsWith("xl/"))return{ext:"xlsx",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};if("mimetype"===i.filename&&i.compressedSize===i.uncompressedSize){switch(await e.readToken(new lib$2.StringType(i.compressedSize,"utf-8"))){case"application/epub+zip":return{ext:"epub",mime:"application/epub+zip"};case"application/vnd.oasis.opendocument.text":return{ext:"odt",mime:"application/vnd.oasis.opendocument.text"};case"application/vnd.oasis.opendocument.spreadsheet":return{ext:"ods",mime:"application/vnd.oasis.opendocument.spreadsheet"};case"application/vnd.oasis.opendocument.presentation":return{ext:"odp",mime:"application/vnd.oasis.opendocument.presentation"}}}if(0===i.compressedSize){let i=-1;for(;i<0&&e.position<e.fileInfo.size;)await e.peekBuffer(t,{mayBeLess:!0}),i=t.indexOf("504B0304",0,"hex"),await e.ignore(i>=0?i:t.length)}else await e.ignore(i.compressedSize)}}catch(e){if(!(e instanceof core.EndOfStreamError))throw e}return{ext:"zip",mime:"application/zip"}}if(a("OggS")){await e.ignore(28);const t=Buffer.alloc(8);return await e.readBuffer(t),_check(t,[79,112,117,115,72,101,97,100])?{ext:"opus",mime:"audio/opus"}:_check(t,[128,116,104,101,111,114,97])?{ext:"ogv",mime:"video/ogg"}:_check(t,[1,118,105,100,101,111,0])?{ext:"ogm",mime:"video/ogg"}:_check(t,[127,70,76,65,67])?{ext:"oga",mime:"audio/ogg"}:_check(t,[83,112,101,101,120,32,32])?{ext:"spx",mime:"audio/ogg"}:_check(t,[1,118,111,114,98,105,115])?{ext:"ogg",mime:"audio/ogg"}:{ext:"ogx",mime:"application/ogg"}}if(i([80,75])&&(3===t[2]||5===t[2]||7===t[2])&&(4===t[3]||6===t[3]||8===t[3]))return{ext:"zip",mime:"application/zip"};if(a("ftyp",{offset:4})&&0!=(96&t[8])){const e=t.toString("binary",8,12).replace("\0"," ").trim();switch(e){case"avif":return{ext:"avif",mime:"image/avif"};case"mif1":return{ext:"heic",mime:"image/heif"};case"msf1":return{ext:"heic",mime:"image/heif-sequence"};case"heic":case"heix":return{ext:"heic",mime:"image/heic"};case"hevc":case"hevx":return{ext:"heic",mime:"image/heic-sequence"};case"qt":return{ext:"mov",mime:"video/quicktime"};case"M4V":case"M4VH":case"M4VP":return{ext:"m4v",mime:"video/x-m4v"};case"M4P":return{ext:"m4p",mime:"video/mp4"};case"M4B":return{ext:"m4b",mime:"audio/mp4"};case"M4A":return{ext:"m4a",mime:"audio/x-m4a"};case"F4V":return{ext:"f4v",mime:"video/mp4"};case"F4P":return{ext:"f4p",mime:"video/mp4"};case"F4A":return{ext:"f4a",mime:"audio/mp4"};case"F4B":return{ext:"f4b",mime:"audio/mp4"};case"crx":return{ext:"cr3",mime:"image/x-canon-cr3"};default:return e.startsWith("3g")?e.startsWith("3g2")?{ext:"3g2",mime:"video/3gpp2"}:{ext:"3gp",mime:"video/3gpp"}:{ext:"mp4",mime:"video/mp4"}}}if(a("MThd"))return{ext:"mid",mime:"audio/midi"};if(a("wOFF")&&(i([0,1,0,0],{offset:4})||a("OTTO",{offset:4})))return{ext:"woff",mime:"font/woff"};if(a("wOF2")&&(i([0,1,0,0],{offset:4})||a("OTTO",{offset:4})))return{ext:"woff2",mime:"font/woff2"};if(i([212,195,178,161])||i([161,178,195,212]))return{ext:"pcap",mime:"application/vnd.tcpdump.pcap"};if(a("DSD "))return{ext:"dsf",mime:"audio/x-dsf"};if(a("LZIP"))return{ext:"lz",mime:"application/x-lzip"};if(a("fLaC"))return{ext:"flac",mime:"audio/x-flac"};if(i([66,80,71,251]))return{ext:"bpg",mime:"image/bpg"};if(a("wvpk"))return{ext:"wv",mime:"audio/wavpack"};if(a("%PDF")){return await(n="Adobe Illustrator",r=1350,_checkSequence(n,e,r))?{ext:"ai",mime:"application/postscript"}:{ext:"pdf",mime:"application/pdf"}}var n,r;if(i([0,97,115,109]))return{ext:"wasm",mime:"application/wasm"};if(i([73,73,42,0]))return a("CR",{offset:8})?{ext:"cr2",mime:"image/x-canon-cr2"}:i([28,0,254,0],{offset:8})||i([31,0,11,0],{offset:8})?{ext:"nef",mime:"image/x-nikon-nef"}:i([8,0,0,0],{offset:4})&&(i([45,0,254,0],{offset:8})||i([39,0,254,0],{offset:8}))?{ext:"dng",mime:"image/x-adobe-dng"}:(t=Buffer.alloc(24),await e.peekBuffer(t),(i([16,251,134,1],{offset:4})||i([8,0,0,0],{offset:4}))&&i([0,254,0,4,0,1,0,0,0,1,0,0,0,3,1],{offset:9})?{ext:"arw",mime:"image/x-sony-arw"}:{ext:"tif",mime:"image/tiff"});if(i([77,77,0,42]))return{ext:"tif",mime:"image/tiff"};if(a("MAC "))return{ext:"ape",mime:"audio/ape"};if(i([26,69,223,163])){async function o(){const t=await e.peekNumber(lib$2.UINT8);let i=128,a=0;for(;0==(t&i);)++a,i>>=1;const n=Buffer.alloc(a+1);return await e.readBuffer(n),n}async function s(){const e=await o(),t=await o();t[0]^=128>>t.length-1;const i=Math.min(6,t.length);return{id:e.readUIntBE(0,e.length),len:t.readUIntBE(t.length-i,i)}}const t=await s();switch(await async function(t,i){for(;i>0;){const t=await s();if(17026===t.id)return e.readToken(new lib$2.StringType(t.len,"utf-8"));await e.ignore(t.len),--i}}(0,t.len)){case"webm":return{ext:"webm",mime:"video/webm"};case"matroska":return{ext:"mkv",mime:"video/x-matroska"};default:return}}if(i([82,73,70,70])){if(i([65,86,73],{offset:8}))return{ext:"avi",mime:"video/vnd.avi"};if(i([87,65,86,69],{offset:8}))return{ext:"wav",mime:"audio/vnd.wave"};if(i([81,76,67,77],{offset:8}))return{ext:"qcp",mime:"audio/qcelp"}}if(a("SQLi"))return{ext:"sqlite",mime:"application/x-sqlite3"};if(i([78,69,83,26]))return{ext:"nes",mime:"application/x-nintendo-nes-rom"};if(a("Cr24"))return{ext:"crx",mime:"application/x-google-chrome-extension"};if(a("MSCF")||a("ISc("))return{ext:"cab",mime:"application/vnd.ms-cab-compressed"};if(i([237,171,238,219]))return{ext:"rpm",mime:"application/x-rpm"};if(i([197,208,211,198]))return{ext:"eps",mime:"application/eps"};if(i([79,84,84,79,0]))return{ext:"otf",mime:"font/otf"};if(a("#!AMR"))return{ext:"amr",mime:"audio/amr"};if(a("{\\rtf"))return{ext:"rtf",mime:"application/rtf"};if(i([70,76,86,1]))return{ext:"flv",mime:"video/x-flv"};if(a("IMPM"))return{ext:"it",mime:"audio/x-it"};if(a("-lh0-",{offset:2})||a("-lh1-",{offset:2})||a("-lh2-",{offset:2})||a("-lh3-",{offset:2})||a("-lh4-",{offset:2})||a("-lh5-",{offset:2})||a("-lh6-",{offset:2})||a("-lh7-",{offset:2})||a("-lzs-",{offset:2})||a("-lz4-",{offset:2})||a("-lz5-",{offset:2})||a("-lhd-",{offset:2}))return{ext:"lzh",mime:"application/x-lzh-compressed"};if(i([0,0,1,186])){if(i([33],{offset:4,mask:[241]}))return{ext:"mpg",mime:"video/MP1S"};if(i([68],{offset:4,mask:[196]}))return{ext:"mpg",mime:"video/MP2P"}}if(i([253,55,122,88,90,0]))return{ext:"xz",mime:"application/x-xz"};if(a("<?xml "))return{ext:"xml",mime:"application/xml"};if(a("BEGIN:"))return{ext:"ics",mime:"text/calendar"};if(i([55,122,188,175,39,28]))return{ext:"7z",mime:"application/x-7z-compressed"};if(i([82,97,114,33,26,7])&&(0===t[6]||1===t[6]))return{ext:"rar",mime:"application/x-rar-compressed"};if(a("BLENDER"))return{ext:"blend",mime:"application/x-blender"};if(a("!<arch>")){await e.ignore(8);return"debian-binary"===await e.readToken(new lib$2.StringType(13,"ascii"))?{ext:"deb",mime:"application/x-deb"}:{ext:"ar",mime:"application/x-unix-archive"}}if(i([137,80,78,71,13,10,26,10])){async function p(){return{length:await e.readToken(lib$2.INT32_BE),type:await e.readToken(new lib$2.StringType(4,"binary"))}}await e.ignore(8);do{const t=await p();switch(t.type){case"IDAT":return{ext:"png",mime:"image/png"};case"acTL":return{ext:"apng",mime:"image/apng"};default:await e.ignore(t.length+4)}}while(e.position<e.fileInfo.size);return{ext:"png",mime:"image/png"}}if(i([65,82,82,79,87,49,0,0]))return{ext:"arrow",mime:"application/x-apache-arrow"};if(i([103,108,84,70,2,0,0,0]))return{ext:"glb",mime:"model/gltf-binary"};if(i([102,114,101,101],{offset:4})||i([109,100,97,116],{offset:4})||i([109,111,111,118],{offset:4})||i([119,105,100,101],{offset:4}))return{ext:"mov",mime:"video/quicktime"};if(i([73,73,82,79,8,0,0,0,24]))return{ext:"orf",mime:"image/x-olympus-orf"};if(i([73,73,85,0,24,0,0,0,136,231,116,216]))return{ext:"rw2",mime:"image/x-panasonic-rw2"};if(i([48,38,178,117,142,102,207,17,166,217])){async function c(){const t=Buffer.alloc(16);return await e.readBuffer(t),{id:t,size:await e.readToken(lib$2.UINT64_LE)}}for(await e.ignore(30);e.position+24<e.fileInfo.size;){const t=await c();let i=t.size-24;if(_check(t.id,[145,7,220,183,183,169,207,17,142,230,0,192,12,32,83,101])){const t=Buffer.alloc(16);if(i-=await e.readBuffer(t),_check(t,[64,158,105,248,77,91,207,17,168,253,0,128,95,92,68,43]))return{ext:"wma",mime:"audio/x-ms-wma"};if(_check(t,[192,239,25,188,77,91,207,17,168,253,0,128,95,92,68,43]))return{ext:"wmv",mime:"video/x-ms-asf"};break}await e.ignore(i)}return{ext:"asf",mime:"application/vnd.ms-asf"}}if(i([171,75,84,88,32,49,49,187,13,10,26,10]))return{ext:"ktx",mime:"image/ktx"};if((i([126,16,4])||i([126,24,4]))&&i([48,77,73,69],{offset:4}))return{ext:"mie",mime:"application/x-mie"};if(i([39,10,0,0,0,0,0,0,0,0,0,0],{offset:2}))return{ext:"shp",mime:"application/x-esri-shape"};if(i([0,0,0,12,106,80,32,32,13,10,135,10])){await e.ignore(20);switch(await e.readToken(new lib$2.StringType(4,"ascii"))){case"jp2 ":return{ext:"jp2",mime:"image/jp2"};case"jpx ":return{ext:"jpx",mime:"image/jpx"};case"jpm ":return{ext:"jpm",mime:"image/jpm"};case"mjp2":return{ext:"mj2",mime:"image/mj2"};default:return}}if(i([0,0,1,186])||i([0,0,1,179]))return{ext:"mpg",mime:"video/mpeg"};if(i([0,1,0,0,0]))return{ext:"ttf",mime:"font/ttf"};if(i([0,0,1,0]))return{ext:"ico",mime:"image/x-icon"};if(i([0,0,2,0]))return{ext:"cur",mime:"image/x-icon"};if(await e.peekBuffer(t,{length:Math.min(256,e.fileInfo.size),mayBeLess:!0}),a("FUJIFILMCCD-RAW"))return{ext:"raf",mime:"image/x-fujifilm-raf"};if(a("Extended Module:"))return{ext:"xm",mime:"audio/x-xm"};if(a("Creative Voice File"))return{ext:"voc",mime:"audio/x-voc"};if(i([4,0,0,0])&&t.length>=16){const e=t.readUInt32LE(12);if(e>12&&e<240&&t.length>=e+16)try{const i=t.slice(16,e+16).toString();if(JSON.parse(i).files)return{ext:"asar",mime:"application/x-asar"}}catch(e){}}if(i([208,207,17,224,161,177,26,225,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62]))return{ext:"msi",mime:"application/x-msi"};if(i([6,14,43,52,2,5,1,1,13,1,2,1,1,2]))return{ext:"mxf",mime:"application/mxf"};if(a("SCRM",{offset:44}))return{ext:"s3m",mime:"audio/x-s3m"};if(i([71],{offset:4})&&(i([71],{offset:192})||i([71],{offset:196})))return{ext:"mts",mime:"video/mp2t"};if(i([66,79,79,75,77,79,66,73],{offset:60}))return{ext:"mobi",mime:"application/x-mobipocket-ebook"};if(i([68,73,67,77],{offset:128}))return{ext:"dcm",mime:"application/dicom"};if(i([76,0,0,0,1,20,2,0,0,0,0,0,192,0,0,0,0,0,0,70]))return{ext:"lnk",mime:"application/x.ms.shortcut"};if(i([98,111,111,107,0,0,0,0,109,97,114,107,0,0,0,0]))return{ext:"alias",mime:"application/x.apple.alias"};if(i([76,80],{offset:34})&&(i([0,0,1],{offset:8})||i([1,0,2],{offset:8})||i([2,0,2],{offset:8})))return{ext:"eot",mime:"application/vnd.ms-fontobject"};if(i([6,6,237,245,216,29,70,229,189,49,239,231,254,116,183,29]))return{ext:"indd",mime:"application/x-indesign"};if(await e.peekBuffer(t,{length:Math.min(512,e.fileInfo.size),mayBeLess:!0}),tarHeaderChecksumMatches$1(t))return{ext:"tar",mime:"application/x-tar"};if(i([255,254,255,14,83,0,107,0,101,0,116,0,99,0,104,0,85,0,112,0,32,0,77,0,111,0,100,0,101,0,108,0]))return{ext:"skp",mime:"application/vnd.sketchup.skp"};if(a("-----BEGIN PGP MESSAGE-----"))return{ext:"pgp",mime:"application/pgp-encrypted"};for(let e=0;e<2&&e<t.length-16;e++)if(t.length>=e+2&&i([255,224],{offset:e,mask:[255,224]})){if(i([16],{offset:e+1,mask:[22]}))return i([8],{offset:e+1,mask:[8]}),{ext:"aac",mime:"audio/aac"};if(i([2],{offset:e+1,mask:[6]}))return{ext:"mp3",mime:"audio/mpeg"};if(i([4],{offset:e+1,mask:[6]}))return{ext:"mp2",mime:"audio/mpeg"};if(i([6],{offset:e+1,mask:[6]}))return{ext:"mp1",mime:"audio/mpeg"}}}const stream=readableStream=>new Promise(((resolve,reject)=>{const stream=eval("require")("stream");readableStream.on("error",reject),readableStream.once("readable",(async()=>{const e=new stream.PassThrough;let t;t=stream.pipeline?stream.pipeline(readableStream,e,(()=>{})):readableStream.pipe(e);const i=readableStream.read(minimumBytes)||readableStream.read()||Buffer.alloc(0);try{const t=await fromBuffer(i);e.fileType=t}catch(e){reject(e)}resolve(t)}))})),fileType={fromStream:fromStream,fromTokenizer:fromTokenizer,fromBuffer:fromBuffer,stream:stream};Object.defineProperty(fileType,"extensions",{get:()=>new Set(supported.extensions)}),Object.defineProperty(fileType,"mimeTypes",{get:()=>new Set(supported.mimeTypes)});var core$1=fileType;async function fromFile(e){const t=await lib$1.fromFile(e);try{return await core$1.fromTokenizer(t)}finally{await t.close()}}const fileType$1={fromFile:fromFile};Object.assign(fileType$1,core$1),Object.defineProperty(fileType$1,"extensions",{get:()=>core$1.extensions}),Object.defineProperty(fileType$1,"mimeTypes",{get:()=>core$1.mimeTypes});var fileType_1=fileType$1;function Mime(){this._types=Object.create(null),this._extensions=Object.create(null);for(var e=0;e<arguments.length;e++)this.define(arguments[e]);this.define=this.define.bind(this),this.getType=this.getType.bind(this),this.getExtension=this.getExtension.bind(this)}Mime.prototype.define=function(e,t){for(var i in e){var a=e[i].map((function(e){return e.toLowerCase()}));i=i.toLowerCase();for(var n=0;n<a.length;n++){if("*"!=(r=a[n])[0]){if(!t&&r in this._types)throw new Error('Attempt to change mapping for "'+r+'" extension from "'+this._types[r]+'" to "'+i+'". Pass `force=true` to allow this, otherwise remove "'+r+'" from the list of extensions for "'+i+'".');this._types[r]=i}}if(t||!this._extensions[i]){var r=a[0];this._extensions[i]="*"!=r[0]?r:r.substr(1)}}},Mime.prototype.getType=function(e){var t=(e=String(e)).replace(/^.*[/\\]/,"").toLowerCase(),i=t.replace(/^.*\./,"").toLowerCase(),a=t.length<e.length;return(i.length<t.length-1||!a)&&this._types[i]||null},Mime.prototype.getExtension=function(e){return(e=/^\s*([^;\s]*)/.test(e)&&RegExp.$1)&&this._extensions[e.toLowerCase()]||null};var Mime_1=Mime,standard={"application/andrew-inset":["ez"],"application/applixware":["aw"],"application/atom+xml":["atom"],"application/atomcat+xml":["atomcat"],"application/atomdeleted+xml":["atomdeleted"],"application/atomsvc+xml":["atomsvc"],"application/atsc-dwd+xml":["dwd"],"application/atsc-held+xml":["held"],"application/atsc-rsat+xml":["rsat"],"application/bdoc":["bdoc"],"application/calendar+xml":["xcs"],"application/ccxml+xml":["ccxml"],"application/cdfx+xml":["cdfx"],"application/cdmi-capability":["cdmia"],"application/cdmi-container":["cdmic"],"application/cdmi-domain":["cdmid"],"application/cdmi-object":["cdmio"],"application/cdmi-queue":["cdmiq"],"application/cu-seeme":["cu"],"application/dash+xml":["mpd"],"application/davmount+xml":["davmount"],"application/docbook+xml":["dbk"],"application/dssc+der":["dssc"],"application/dssc+xml":["xdssc"],"application/ecmascript":["ecma","es"],"application/emma+xml":["emma"],"application/emotionml+xml":["emotionml"],"application/epub+zip":["epub"],"application/exi":["exi"],"application/fdt+xml":["fdt"],"application/font-tdpfr":["pfr"],"application/geo+json":["geojson"],"application/gml+xml":["gml"],"application/gpx+xml":["gpx"],"application/gxf":["gxf"],"application/gzip":["gz"],"application/hjson":["hjson"],"application/hyperstudio":["stk"],"application/inkml+xml":["ink","inkml"],"application/ipfix":["ipfix"],"application/its+xml":["its"],"application/java-archive":["jar","war","ear"],"application/java-serialized-object":["ser"],"application/java-vm":["class"],"application/javascript":["js","mjs"],"application/json":["json","map"],"application/json5":["json5"],"application/jsonml+json":["jsonml"],"application/ld+json":["jsonld"],"application/lgr+xml":["lgr"],"application/lost+xml":["lostxml"],"application/mac-binhex40":["hqx"],"application/mac-compactpro":["cpt"],"application/mads+xml":["mads"],"application/manifest+json":["webmanifest"],"application/marc":["mrc"],"application/marcxml+xml":["mrcx"],"application/mathematica":["ma","nb","mb"],"application/mathml+xml":["mathml"],"application/mbox":["mbox"],"application/mediaservercontrol+xml":["mscml"],"application/metalink+xml":["metalink"],"application/metalink4+xml":["meta4"],"application/mets+xml":["mets"],"application/mmt-aei+xml":["maei"],"application/mmt-usd+xml":["musd"],"application/mods+xml":["mods"],"application/mp21":["m21","mp21"],"application/mp4":["mp4s","m4p"],"application/mrb-consumer+xml":["*xdf"],"application/mrb-publish+xml":["*xdf"],"application/msword":["doc","dot"],"application/mxf":["mxf"],"application/n-quads":["nq"],"application/n-triples":["nt"],"application/node":["cjs"],"application/octet-stream":["bin","dms","lrf","mar","so","dist","distz","pkg","bpk","dump","elc","deploy","exe","dll","deb","dmg","iso","img","msi","msp","msm","buffer"],"application/oda":["oda"],"application/oebps-package+xml":["opf"],"application/ogg":["ogx"],"application/omdoc+xml":["omdoc"],"application/onenote":["onetoc","onetoc2","onetmp","onepkg"],"application/oxps":["oxps"],"application/p2p-overlay+xml":["relo"],"application/patch-ops-error+xml":["*xer"],"application/pdf":["pdf"],"application/pgp-encrypted":["pgp"],"application/pgp-signature":["asc","sig"],"application/pics-rules":["prf"],"application/pkcs10":["p10"],"application/pkcs7-mime":["p7m","p7c"],"application/pkcs7-signature":["p7s"],"application/pkcs8":["p8"],"application/pkix-attr-cert":["ac"],"application/pkix-cert":["cer"],"application/pkix-crl":["crl"],"application/pkix-pkipath":["pkipath"],"application/pkixcmp":["pki"],"application/pls+xml":["pls"],"application/postscript":["ai","eps","ps"],"application/provenance+xml":["provx"],"application/pskc+xml":["pskcxml"],"application/raml+yaml":["raml"],"application/rdf+xml":["rdf","owl"],"application/reginfo+xml":["rif"],"application/relax-ng-compact-syntax":["rnc"],"application/resource-lists+xml":["rl"],"application/resource-lists-diff+xml":["rld"],"application/rls-services+xml":["rs"],"application/route-apd+xml":["rapd"],"application/route-s-tsid+xml":["sls"],"application/route-usd+xml":["rusd"],"application/rpki-ghostbusters":["gbr"],"application/rpki-manifest":["mft"],"application/rpki-roa":["roa"],"application/rsd+xml":["rsd"],"application/rss+xml":["rss"],"application/rtf":["rtf"],"application/sbml+xml":["sbml"],"application/scvp-cv-request":["scq"],"application/scvp-cv-response":["scs"],"application/scvp-vp-request":["spq"],"application/scvp-vp-response":["spp"],"application/sdp":["sdp"],"application/senml+xml":["senmlx"],"application/sensml+xml":["sensmlx"],"application/set-payment-initiation":["setpay"],"application/set-registration-initiation":["setreg"],"application/shf+xml":["shf"],"application/sieve":["siv","sieve"],"application/smil+xml":["smi","smil"],"application/sparql-query":["rq"],"application/sparql-results+xml":["srx"],"application/srgs":["gram"],"application/srgs+xml":["grxml"],"application/sru+xml":["sru"],"application/ssdl+xml":["ssdl"],"application/ssml+xml":["ssml"],"application/swid+xml":["swidtag"],"application/tei+xml":["tei","teicorpus"],"application/thraud+xml":["tfi"],"application/timestamped-data":["tsd"],"application/toml":["toml"],"application/ttml+xml":["ttml"],"application/urc-ressheet+xml":["rsheet"],"application/voicexml+xml":["vxml"],"application/wasm":["wasm"],"application/widget":["wgt"],"application/winhlp":["hlp"],"application/wsdl+xml":["wsdl"],"application/wspolicy+xml":["wspolicy"],"application/xaml+xml":["xaml"],"application/xcap-att+xml":["xav"],"application/xcap-caps+xml":["xca"],"application/xcap-diff+xml":["xdf"],"application/xcap-el+xml":["xel"],"application/xcap-error+xml":["xer"],"application/xcap-ns+xml":["xns"],"application/xenc+xml":["xenc"],"application/xhtml+xml":["xhtml","xht"],"application/xliff+xml":["xlf"],"application/xml":["xml","xsl","xsd","rng"],"application/xml-dtd":["dtd"],"application/xop+xml":["xop"],"application/xproc+xml":["xpl"],"application/xslt+xml":["xslt"],"application/xspf+xml":["xspf"],"application/xv+xml":["mxml","xhvml","xvml","xvm"],"application/yang":["yang"],"application/yin+xml":["yin"],"application/zip":["zip"],"audio/3gpp":["*3gpp"],"audio/adpcm":["adp"],"audio/basic":["au","snd"],"audio/midi":["mid","midi","kar","rmi"],"audio/mobile-xmf":["mxmf"],"audio/mp3":["*mp3"],"audio/mp4":["m4a","mp4a"],"audio/mpeg":["mpga","mp2","mp2a","mp3","m2a","m3a"],"audio/ogg":["oga","ogg","spx"],"audio/s3m":["s3m"],"audio/silk":["sil"],"audio/wav":["wav"],"audio/wave":["*wav"],"audio/webm":["weba"],"audio/xm":["xm"],"font/collection":["ttc"],"font/otf":["otf"],"font/ttf":["ttf"],"font/woff":["woff"],"font/woff2":["woff2"],"image/aces":["exr"],"image/apng":["apng"],"image/bmp":["bmp"],"image/cgm":["cgm"],"image/dicom-rle":["drle"],"image/emf":["emf"],"image/fits":["fits"],"image/g3fax":["g3"],"image/gif":["gif"],"image/heic":["heic"],"image/heic-sequence":["heics"],"image/heif":["heif"],"image/heif-sequence":["heifs"],"image/hej2k":["hej2"],"image/hsj2":["hsj2"],"image/ief":["ief"],"image/jls":["jls"],"image/jp2":["jp2","jpg2"],"image/jpeg":["jpeg","jpg","jpe"],"image/jph":["jph"],"image/jphc":["jhc"],"image/jpm":["jpm"],"image/jpx":["jpx","jpf"],"image/jxr":["jxr"],"image/jxra":["jxra"],"image/jxrs":["jxrs"],"image/jxs":["jxs"],"image/jxsc":["jxsc"],"image/jxsi":["jxsi"],"image/jxss":["jxss"],"image/ktx":["ktx"],"image/png":["png"],"image/sgi":["sgi"],"image/svg+xml":["svg","svgz"],"image/t38":["t38"],"image/tiff":["tif","tiff"],"image/tiff-fx":["tfx"],"image/webp":["webp"],"image/wmf":["wmf"],"message/disposition-notification":["disposition-notification"],"message/global":["u8msg"],"message/global-delivery-status":["u8dsn"],"message/global-disposition-notification":["u8mdn"],"message/global-headers":["u8hdr"],"message/rfc822":["eml","mime"],"model/3mf":["3mf"],"model/gltf+json":["gltf"],"model/gltf-binary":["glb"],"model/iges":["igs","iges"],"model/mesh":["msh","mesh","silo"],"model/mtl":["mtl"],"model/obj":["obj"],"model/stl":["stl"],"model/vrml":["wrl","vrml"],"model/x3d+binary":["*x3db","x3dbz"],"model/x3d+fastinfoset":["x3db"],"model/x3d+vrml":["*x3dv","x3dvz"],"model/x3d+xml":["x3d","x3dz"],"model/x3d-vrml":["x3dv"],"text/cache-manifest":["appcache","manifest"],"text/calendar":["ics","ifb"],"text/coffeescript":["coffee","litcoffee"],"text/css":["css"],"text/csv":["csv"],"text/html":["html","htm","shtml"],"text/jade":["jade"],"text/jsx":["jsx"],"text/less":["less"],"text/markdown":["markdown","md"],"text/mathml":["mml"],"text/mdx":["mdx"],"text/n3":["n3"],"text/plain":["txt","text","conf","def","list","log","in","ini"],"text/richtext":["rtx"],"text/rtf":["*rtf"],"text/sgml":["sgml","sgm"],"text/shex":["shex"],"text/slim":["slim","slm"],"text/stylus":["stylus","styl"],"text/tab-separated-values":["tsv"],"text/troff":["t","tr","roff","man","me","ms"],"text/turtle":["ttl"],"text/uri-list":["uri","uris","urls"],"text/vcard":["vcard"],"text/vtt":["vtt"],"text/xml":["*xml"],"text/yaml":["yaml","yml"],"video/3gpp":["3gp","3gpp"],"video/3gpp2":["3g2"],"video/h261":["h261"],"video/h263":["h263"],"video/h264":["h264"],"video/jpeg":["jpgv"],"video/jpm":["*jpm","jpgm"],"video/mj2":["mj2","mjp2"],"video/mp2t":["ts"],"video/mp4":["mp4","mp4v","mpg4"],"video/mpeg":["mpeg","mpg","mpe","m1v","m2v"],"video/ogg":["ogv"],"video/quicktime":["qt","mov"],"video/webm":["webm"]},other={"application/prs.cww":["cww"],"application/vnd.1000minds.decision-model+xml":["1km"],"application/vnd.3gpp.pic-bw-large":["plb"],"application/vnd.3gpp.pic-bw-small":["psb"],"application/vnd.3gpp.pic-bw-var":["pvb"],"application/vnd.3gpp2.tcap":["tcap"],"application/vnd.3m.post-it-notes":["pwn"],"application/vnd.accpac.simply.aso":["aso"],"application/vnd.accpac.simply.imp":["imp"],"application/vnd.acucobol":["acu"],"application/vnd.acucorp":["atc","acutc"],"application/vnd.adobe.air-application-installer-package+zip":["air"],"application/vnd.adobe.formscentral.fcdt":["fcdt"],"application/vnd.adobe.fxp":["fxp","fxpl"],"application/vnd.adobe.xdp+xml":["xdp"],"application/vnd.adobe.xfdf":["xfdf"],"application/vnd.ahead.space":["ahead"],"application/vnd.airzip.filesecure.azf":["azf"],"application/vnd.airzip.filesecure.azs":["azs"],"application/vnd.amazon.ebook":["azw"],"application/vnd.americandynamics.acc":["acc"],"application/vnd.amiga.ami":["ami"],"application/vnd.android.package-archive":["apk"],"application/vnd.anser-web-certificate-issue-initiation":["cii"],"application/vnd.anser-web-funds-transfer-initiation":["fti"],"application/vnd.antix.game-component":["atx"],"application/vnd.apple.installer+xml":["mpkg"],"application/vnd.apple.keynote":["keynote"],"application/vnd.apple.mpegurl":["m3u8"],"application/vnd.apple.numbers":["numbers"],"application/vnd.apple.pages":["pages"],"application/vnd.apple.pkpass":["pkpass"],"application/vnd.aristanetworks.swi":["swi"],"application/vnd.astraea-software.iota":["iota"],"application/vnd.audiograph":["aep"],"application/vnd.balsamiq.bmml+xml":["bmml"],"application/vnd.blueice.multipass":["mpm"],"application/vnd.bmi":["bmi"],"application/vnd.businessobjects":["rep"],"application/vnd.chemdraw+xml":["cdxml"],"application/vnd.chipnuts.karaoke-mmd":["mmd"],"application/vnd.cinderella":["cdy"],"application/vnd.citationstyles.style+xml":["csl"],"application/vnd.claymore":["cla"],"application/vnd.cloanto.rp9":["rp9"],"application/vnd.clonk.c4group":["c4g","c4d","c4f","c4p","c4u"],"application/vnd.cluetrust.cartomobile-config":["c11amc"],"application/vnd.cluetrust.cartomobile-config-pkg":["c11amz"],"application/vnd.commonspace":["csp"],"application/vnd.contact.cmsg":["cdbcmsg"],"application/vnd.cosmocaller":["cmc"],"application/vnd.crick.clicker":["clkx"],"application/vnd.crick.clicker.keyboard":["clkk"],"application/vnd.crick.clicker.palette":["clkp"],"application/vnd.crick.clicker.template":["clkt"],"application/vnd.crick.clicker.wordbank":["clkw"],"application/vnd.criticaltools.wbs+xml":["wbs"],"application/vnd.ctc-posml":["pml"],"application/vnd.cups-ppd":["ppd"],"application/vnd.curl.car":["car"],"application/vnd.curl.pcurl":["pcurl"],"application/vnd.dart":["dart"],"application/vnd.data-vision.rdz":["rdz"],"application/vnd.dece.data":["uvf","uvvf","uvd","uvvd"],"application/vnd.dece.ttml+xml":["uvt","uvvt"],"application/vnd.dece.unspecified":["uvx","uvvx"],"application/vnd.dece.zip":["uvz","uvvz"],"application/vnd.denovo.fcselayout-link":["fe_launch"],"application/vnd.dna":["dna"],"application/vnd.dolby.mlp":["mlp"],"application/vnd.dpgraph":["dpg"],"application/vnd.dreamfactory":["dfac"],"application/vnd.ds-keypoint":["kpxx"],"application/vnd.dvb.ait":["ait"],"application/vnd.dvb.service":["svc"],"application/vnd.dynageo":["geo"],"application/vnd.ecowin.chart":["mag"],"application/vnd.enliven":["nml"],"application/vnd.epson.esf":["esf"],"application/vnd.epson.msf":["msf"],"application/vnd.epson.quickanime":["qam"],"application/vnd.epson.salt":["slt"],"application/vnd.epson.ssf":["ssf"],"application/vnd.eszigno3+xml":["es3","et3"],"application/vnd.ezpix-album":["ez2"],"application/vnd.ezpix-package":["ez3"],"application/vnd.fdf":["fdf"],"application/vnd.fdsn.mseed":["mseed"],"application/vnd.fdsn.seed":["seed","dataless"],"application/vnd.flographit":["gph"],"application/vnd.fluxtime.clip":["ftc"],"application/vnd.framemaker":["fm","frame","maker","book"],"application/vnd.frogans.fnc":["fnc"],"application/vnd.frogans.ltf":["ltf"],"application/vnd.fsc.weblaunch":["fsc"],"application/vnd.fujitsu.oasys":["oas"],"application/vnd.fujitsu.oasys2":["oa2"],"application/vnd.fujitsu.oasys3":["oa3"],"application/vnd.fujitsu.oasysgp":["fg5"],"application/vnd.fujitsu.oasysprs":["bh2"],"application/vnd.fujixerox.ddd":["ddd"],"application/vnd.fujixerox.docuworks":["xdw"],"application/vnd.fujixerox.docuworks.binder":["xbd"],"application/vnd.fuzzysheet":["fzs"],"application/vnd.genomatix.tuxedo":["txd"],"application/vnd.geogebra.file":["ggb"],"application/vnd.geogebra.tool":["ggt"],"application/vnd.geometry-explorer":["gex","gre"],"application/vnd.geonext":["gxt"],"application/vnd.geoplan":["g2w"],"application/vnd.geospace":["g3w"],"application/vnd.gmx":["gmx"],"application/vnd.google-apps.document":["gdoc"],"application/vnd.google-apps.presentation":["gslides"],"application/vnd.google-apps.spreadsheet":["gsheet"],"application/vnd.google-earth.kml+xml":["kml"],"application/vnd.google-earth.kmz":["kmz"],"application/vnd.grafeq":["gqf","gqs"],"application/vnd.groove-account":["gac"],"application/vnd.groove-help":["ghf"],"application/vnd.groove-identity-message":["gim"],"application/vnd.groove-injector":["grv"],"application/vnd.groove-tool-message":["gtm"],"application/vnd.groove-tool-template":["tpl"],"application/vnd.groove-vcard":["vcg"],"application/vnd.hal+xml":["hal"],"application/vnd.handheld-entertainment+xml":["zmm"],"application/vnd.hbci":["hbci"],"application/vnd.hhe.lesson-player":["les"],"application/vnd.hp-hpgl":["hpgl"],"application/vnd.hp-hpid":["hpid"],"application/vnd.hp-hps":["hps"],"application/vnd.hp-jlyt":["jlt"],"application/vnd.hp-pcl":["pcl"],"application/vnd.hp-pclxl":["pclxl"],"application/vnd.hydrostatix.sof-data":["sfd-hdstx"],"application/vnd.ibm.minipay":["mpy"],"application/vnd.ibm.modcap":["afp","listafp","list3820"],"application/vnd.ibm.rights-management":["irm"],"application/vnd.ibm.secure-container":["sc"],"application/vnd.iccprofile":["icc","icm"],"application/vnd.igloader":["igl"],"application/vnd.immervision-ivp":["ivp"],"application/vnd.immervision-ivu":["ivu"],"application/vnd.insors.igm":["igm"],"application/vnd.intercon.formnet":["xpw","xpx"],"application/vnd.intergeo":["i2g"],"application/vnd.intu.qbo":["qbo"],"application/vnd.intu.qfx":["qfx"],"application/vnd.ipunplugged.rcprofile":["rcprofile"],"application/vnd.irepository.package+xml":["irp"],"application/vnd.is-xpr":["xpr"],"application/vnd.isac.fcs":["fcs"],"application/vnd.jam":["jam"],"application/vnd.jcp.javame.midlet-rms":["rms"],"application/vnd.jisp":["jisp"],"application/vnd.joost.joda-archive":["joda"],"application/vnd.kahootz":["ktz","ktr"],"application/vnd.kde.karbon":["karbon"],"application/vnd.kde.kchart":["chrt"],"application/vnd.kde.kformula":["kfo"],"application/vnd.kde.kivio":["flw"],"application/vnd.kde.kontour":["kon"],"application/vnd.kde.kpresenter":["kpr","kpt"],"application/vnd.kde.kspread":["ksp"],"application/vnd.kde.kword":["kwd","kwt"],"application/vnd.kenameaapp":["htke"],"application/vnd.kidspiration":["kia"],"application/vnd.kinar":["kne","knp"],"application/vnd.koan":["skp","skd","skt","skm"],"application/vnd.kodak-descriptor":["sse"],"application/vnd.las.las+xml":["lasxml"],"application/vnd.llamagraphics.life-balance.desktop":["lbd"],"application/vnd.llamagraphics.life-balance.exchange+xml":["lbe"],"application/vnd.lotus-1-2-3":["123"],"application/vnd.lotus-approach":["apr"],"application/vnd.lotus-freelance":["pre"],"application/vnd.lotus-notes":["nsf"],"application/vnd.lotus-organizer":["org"],"application/vnd.lotus-screencam":["scm"],"application/vnd.lotus-wordpro":["lwp"],"application/vnd.macports.portpkg":["portpkg"],"application/vnd.mcd":["mcd"],"application/vnd.medcalcdata":["mc1"],"application/vnd.mediastation.cdkey":["cdkey"],"application/vnd.mfer":["mwf"],"application/vnd.mfmp":["mfm"],"application/vnd.micrografx.flo":["flo"],"application/vnd.micrografx.igx":["igx"],"application/vnd.mif":["mif"],"application/vnd.mobius.daf":["daf"],"application/vnd.mobius.dis":["dis"],"application/vnd.mobius.mbk":["mbk"],"application/vnd.mobius.mqy":["mqy"],"application/vnd.mobius.msl":["msl"],"application/vnd.mobius.plc":["plc"],"application/vnd.mobius.txf":["txf"],"application/vnd.mophun.application":["mpn"],"application/vnd.mophun.certificate":["mpc"],"application/vnd.mozilla.xul+xml":["xul"],"application/vnd.ms-artgalry":["cil"],"application/vnd.ms-cab-compressed":["cab"],"application/vnd.ms-excel":["xls","xlm","xla","xlc","xlt","xlw"],"application/vnd.ms-excel.addin.macroenabled.12":["xlam"],"application/vnd.ms-excel.sheet.binary.macroenabled.12":["xlsb"],"application/vnd.ms-excel.sheet.macroenabled.12":["xlsm"],"application/vnd.ms-excel.template.macroenabled.12":["xltm"],"application/vnd.ms-fontobject":["eot"],"application/vnd.ms-htmlhelp":["chm"],"application/vnd.ms-ims":["ims"],"application/vnd.ms-lrm":["lrm"],"application/vnd.ms-officetheme":["thmx"],"application/vnd.ms-outlook":["msg"],"application/vnd.ms-pki.seccat":["cat"],"application/vnd.ms-pki.stl":["*stl"],"application/vnd.ms-powerpoint":["ppt","pps","pot"],"application/vnd.ms-powerpoint.addin.macroenabled.12":["ppam"],"application/vnd.ms-powerpoint.presentation.macroenabled.12":["pptm"],"application/vnd.ms-powerpoint.slide.macroenabled.12":["sldm"],"application/vnd.ms-powerpoint.slideshow.macroenabled.12":["ppsm"],"application/vnd.ms-powerpoint.template.macroenabled.12":["potm"],"application/vnd.ms-project":["mpp","mpt"],"application/vnd.ms-word.document.macroenabled.12":["docm"],"application/vnd.ms-word.template.macroenabled.12":["dotm"],"application/vnd.ms-works":["wps","wks","wcm","wdb"],"application/vnd.ms-wpl":["wpl"],"application/vnd.ms-xpsdocument":["xps"],"application/vnd.mseq":["mseq"],"application/vnd.musician":["mus"],"application/vnd.muvee.style":["msty"],"application/vnd.mynfc":["taglet"],"application/vnd.neurolanguage.nlu":["nlu"],"application/vnd.nitf":["ntf","nitf"],"application/vnd.noblenet-directory":["nnd"],"application/vnd.noblenet-sealer":["nns"],"application/vnd.noblenet-web":["nnw"],"application/vnd.nokia.n-gage.ac+xml":["*ac"],"application/vnd.nokia.n-gage.data":["ngdat"],"application/vnd.nokia.n-gage.symbian.install":["n-gage"],"application/vnd.nokia.radio-preset":["rpst"],"application/vnd.nokia.radio-presets":["rpss"],"application/vnd.novadigm.edm":["edm"],"application/vnd.novadigm.edx":["edx"],"application/vnd.novadigm.ext":["ext"],"application/vnd.oasis.opendocument.chart":["odc"],"application/vnd.oasis.opendocument.chart-template":["otc"],"application/vnd.oasis.opendocument.database":["odb"],"application/vnd.oasis.opendocument.formula":["odf"],"application/vnd.oasis.opendocument.formula-template":["odft"],"application/vnd.oasis.opendocument.graphics":["odg"],"application/vnd.oasis.opendocument.graphics-template":["otg"],"application/vnd.oasis.opendocument.image":["odi"],"application/vnd.oasis.opendocument.image-template":["oti"],"application/vnd.oasis.opendocument.presentation":["odp"],"application/vnd.oasis.opendocument.presentation-template":["otp"],"application/vnd.oasis.opendocument.spreadsheet":["ods"],"application/vnd.oasis.opendocument.spreadsheet-template":["ots"],"application/vnd.oasis.opendocument.text":["odt"],"application/vnd.oasis.opendocument.text-master":["odm"],"application/vnd.oasis.opendocument.text-template":["ott"],"application/vnd.oasis.opendocument.text-web":["oth"],"application/vnd.olpc-sugar":["xo"],"application/vnd.oma.dd2+xml":["dd2"],"application/vnd.openblox.game+xml":["obgx"],"application/vnd.openofficeorg.extension":["oxt"],"application/vnd.openstreetmap.data+xml":["osm"],"application/vnd.openxmlformats-officedocument.presentationml.presentation":["pptx"],"application/vnd.openxmlformats-officedocument.presentationml.slide":["sldx"],"application/vnd.openxmlformats-officedocument.presentationml.slideshow":["ppsx"],"application/vnd.openxmlformats-officedocument.presentationml.template":["potx"],"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":["xlsx"],"application/vnd.openxmlformats-officedocument.spreadsheetml.template":["xltx"],"application/vnd.openxmlformats-officedocument.wordprocessingml.document":["docx"],"application/vnd.openxmlformats-officedocument.wordprocessingml.template":["dotx"],"application/vnd.osgeo.mapguide.package":["mgp"],"application/vnd.osgi.dp":["dp"],"application/vnd.osgi.subsystem":["esa"],"application/vnd.palm":["pdb","pqa","oprc"],"application/vnd.pawaafile":["paw"],"application/vnd.pg.format":["str"],"application/vnd.pg.osasli":["ei6"],"application/vnd.picsel":["efif"],"application/vnd.pmi.widget":["wg"],"application/vnd.pocketlearn":["plf"],"application/vnd.powerbuilder6":["pbd"],"application/vnd.previewsystems.box":["box"],"application/vnd.proteus.magazine":["mgz"],"application/vnd.publishare-delta-tree":["qps"],"application/vnd.pvi.ptid1":["ptid"],"application/vnd.quark.quarkxpress":["qxd","qxt","qwd","qwt","qxl","qxb"],"application/vnd.realvnc.bed":["bed"],"application/vnd.recordare.musicxml":["mxl"],"application/vnd.recordare.musicxml+xml":["musicxml"],"application/vnd.rig.cryptonote":["cryptonote"],"application/vnd.rim.cod":["cod"],"application/vnd.rn-realmedia":["rm"],"application/vnd.rn-realmedia-vbr":["rmvb"],"application/vnd.route66.link66+xml":["link66"],"application/vnd.sailingtracker.track":["st"],"application/vnd.seemail":["see"],"application/vnd.sema":["sema"],"application/vnd.semd":["semd"],"application/vnd.semf":["semf"],"application/vnd.shana.informed.formdata":["ifm"],"application/vnd.shana.informed.formtemplate":["itp"],"application/vnd.shana.informed.interchange":["iif"],"application/vnd.shana.informed.package":["ipk"],"application/vnd.simtech-mindmapper":["twd","twds"],"application/vnd.smaf":["mmf"],"application/vnd.smart.teacher":["teacher"],"application/vnd.software602.filler.form+xml":["fo"],"application/vnd.solent.sdkm+xml":["sdkm","sdkd"],"application/vnd.spotfire.dxp":["dxp"],"application/vnd.spotfire.sfs":["sfs"],"application/vnd.stardivision.calc":["sdc"],"application/vnd.stardivision.draw":["sda"],"application/vnd.stardivision.impress":["sdd"],"application/vnd.stardivision.math":["smf"],"application/vnd.stardivision.writer":["sdw","vor"],"application/vnd.stardivision.writer-global":["sgl"],"application/vnd.stepmania.package":["smzip"],"application/vnd.stepmania.stepchart":["sm"],"application/vnd.sun.wadl+xml":["wadl"],"application/vnd.sun.xml.calc":["sxc"],"application/vnd.sun.xml.calc.template":["stc"],"application/vnd.sun.xml.draw":["sxd"],"application/vnd.sun.xml.draw.template":["std"],"application/vnd.sun.xml.impress":["sxi"],"application/vnd.sun.xml.impress.template":["sti"],"application/vnd.sun.xml.math":["sxm"],"application/vnd.sun.xml.writer":["sxw"],"application/vnd.sun.xml.writer.global":["sxg"],"application/vnd.sun.xml.writer.template":["stw"],"application/vnd.sus-calendar":["sus","susp"],"application/vnd.svd":["svd"],"application/vnd.symbian.install":["sis","sisx"],"application/vnd.syncml+xml":["xsm"],"application/vnd.syncml.dm+wbxml":["bdm"],"application/vnd.syncml.dm+xml":["xdm"],"application/vnd.syncml.dmddf+xml":["ddf"],"application/vnd.tao.intent-module-archive":["tao"],"application/vnd.tcpdump.pcap":["pcap","cap","dmp"],"application/vnd.tmobile-livetv":["tmo"],"application/vnd.trid.tpt":["tpt"],"application/vnd.triscape.mxs":["mxs"],"application/vnd.trueapp":["tra"],"application/vnd.ufdl":["ufd","ufdl"],"application/vnd.uiq.theme":["utz"],"application/vnd.umajin":["umj"],"application/vnd.unity":["unityweb"],"application/vnd.uoml+xml":["uoml"],"application/vnd.vcx":["vcx"],"application/vnd.visio":["vsd","vst","vss","vsw"],"application/vnd.visionary":["vis"],"application/vnd.vsf":["vsf"],"application/vnd.wap.wbxml":["wbxml"],"application/vnd.wap.wmlc":["wmlc"],"application/vnd.wap.wmlscriptc":["wmlsc"],"application/vnd.webturbo":["wtb"],"application/vnd.wolfram.player":["nbp"],"application/vnd.wordperfect":["wpd"],"application/vnd.wqd":["wqd"],"application/vnd.wt.stf":["stf"],"application/vnd.xara":["xar"],"application/vnd.xfdl":["xfdl"],"application/vnd.yamaha.hv-dic":["hvd"],"application/vnd.yamaha.hv-script":["hvs"],"application/vnd.yamaha.hv-voice":["hvp"],"application/vnd.yamaha.openscoreformat":["osf"],"application/vnd.yamaha.openscoreformat.osfpvg+xml":["osfpvg"],"application/vnd.yamaha.smaf-audio":["saf"],"application/vnd.yamaha.smaf-phrase":["spf"],"application/vnd.yellowriver-custom-menu":["cmp"],"application/vnd.zul":["zir","zirz"],"application/vnd.zzazz.deck+xml":["zaz"],"application/x-7z-compressed":["7z"],"application/x-abiword":["abw"],"application/x-ace-compressed":["ace"],"application/x-apple-diskimage":["*dmg"],"application/x-arj":["arj"],"application/x-authorware-bin":["aab","x32","u32","vox"],"application/x-authorware-map":["aam"],"application/x-authorware-seg":["aas"],"application/x-bcpio":["bcpio"],"application/x-bdoc":["*bdoc"],"application/x-bittorrent":["torrent"],"application/x-blorb":["blb","blorb"],"application/x-bzip":["bz"],"application/x-bzip2":["bz2","boz"],"application/x-cbr":["cbr","cba","cbt","cbz","cb7"],"application/x-cdlink":["vcd"],"application/x-cfs-compressed":["cfs"],"application/x-chat":["chat"],"application/x-chess-pgn":["pgn"],"application/x-chrome-extension":["crx"],"application/x-cocoa":["cco"],"application/x-conference":["nsc"],"application/x-cpio":["cpio"],"application/x-csh":["csh"],"application/x-debian-package":["*deb","udeb"],"application/x-dgc-compressed":["dgc"],"application/x-director":["dir","dcr","dxr","cst","cct","cxt","w3d","fgd","swa"],"application/x-doom":["wad"],"application/x-dtbncx+xml":["ncx"],"application/x-dtbook+xml":["dtb"],"application/x-dtbresource+xml":["res"],"application/x-dvi":["dvi"],"application/x-envoy":["evy"],"application/x-eva":["eva"],"application/x-font-bdf":["bdf"],"application/x-font-ghostscript":["gsf"],"application/x-font-linux-psf":["psf"],"application/x-font-pcf":["pcf"],"application/x-font-snf":["snf"],"application/x-font-type1":["pfa","pfb","pfm","afm"],"application/x-freearc":["arc"],"application/x-futuresplash":["spl"],"application/x-gca-compressed":["gca"],"application/x-glulx":["ulx"],"application/x-gnumeric":["gnumeric"],"application/x-gramps-xml":["gramps"],"application/x-gtar":["gtar"],"application/x-hdf":["hdf"],"application/x-httpd-php":["php"],"application/x-install-instructions":["install"],"application/x-iso9660-image":["*iso"],"application/x-java-archive-diff":["jardiff"],"application/x-java-jnlp-file":["jnlp"],"application/x-keepass2":["kdbx"],"application/x-latex":["latex"],"application/x-lua-bytecode":["luac"],"application/x-lzh-compressed":["lzh","lha"],"application/x-makeself":["run"],"application/x-mie":["mie"],"application/x-mobipocket-ebook":["prc","mobi"],"application/x-ms-application":["application"],"application/x-ms-shortcut":["lnk"],"application/x-ms-wmd":["wmd"],"application/x-ms-wmz":["wmz"],"application/x-ms-xbap":["xbap"],"application/x-msaccess":["mdb"],"application/x-msbinder":["obd"],"application/x-mscardfile":["crd"],"application/x-msclip":["clp"],"application/x-msdos-program":["*exe"],"application/x-msdownload":["*exe","*dll","com","bat","*msi"],"application/x-msmediaview":["mvb","m13","m14"],"application/x-msmetafile":["*wmf","*wmz","*emf","emz"],"application/x-msmoney":["mny"],"application/x-mspublisher":["pub"],"application/x-msschedule":["scd"],"application/x-msterminal":["trm"],"application/x-mswrite":["wri"],"application/x-netcdf":["nc","cdf"],"application/x-ns-proxy-autoconfig":["pac"],"application/x-nzb":["nzb"],"application/x-perl":["pl","pm"],"application/x-pilot":["*prc","*pdb"],"application/x-pkcs12":["p12","pfx"],"application/x-pkcs7-certificates":["p7b","spc"],"application/x-pkcs7-certreqresp":["p7r"],"application/x-rar-compressed":["rar"],"application/x-redhat-package-manager":["rpm"],"application/x-research-info-systems":["ris"],"application/x-sea":["sea"],"application/x-sh":["sh"],"application/x-shar":["shar"],"application/x-shockwave-flash":["swf"],"application/x-silverlight-app":["xap"],"application/x-sql":["sql"],"application/x-stuffit":["sit"],"application/x-stuffitx":["sitx"],"application/x-subrip":["srt"],"application/x-sv4cpio":["sv4cpio"],"application/x-sv4crc":["sv4crc"],"application/x-t3vm-image":["t3"],"application/x-tads":["gam"],"application/x-tar":["tar"],"application/x-tcl":["tcl","tk"],"application/x-tex":["tex"],"application/x-tex-tfm":["tfm"],"application/x-texinfo":["texinfo","texi"],"application/x-tgif":["*obj"],"application/x-ustar":["ustar"],"application/x-virtualbox-hdd":["hdd"],"application/x-virtualbox-ova":["ova"],"application/x-virtualbox-ovf":["ovf"],"application/x-virtualbox-vbox":["vbox"],"application/x-virtualbox-vbox-extpack":["vbox-extpack"],"application/x-virtualbox-vdi":["vdi"],"application/x-virtualbox-vhd":["vhd"],"application/x-virtualbox-vmdk":["vmdk"],"application/x-wais-source":["src"],"application/x-web-app-manifest+json":["webapp"],"application/x-x509-ca-cert":["der","crt","pem"],"application/x-xfig":["fig"],"application/x-xliff+xml":["*xlf"],"application/x-xpinstall":["xpi"],"application/x-xz":["xz"],"application/x-zmachine":["z1","z2","z3","z4","z5","z6","z7","z8"],"audio/vnd.dece.audio":["uva","uvva"],"audio/vnd.digital-winds":["eol"],"audio/vnd.dra":["dra"],"audio/vnd.dts":["dts"],"audio/vnd.dts.hd":["dtshd"],"audio/vnd.lucent.voice":["lvp"],"audio/vnd.ms-playready.media.pya":["pya"],"audio/vnd.nuera.ecelp4800":["ecelp4800"],"audio/vnd.nuera.ecelp7470":["ecelp7470"],"audio/vnd.nuera.ecelp9600":["ecelp9600"],"audio/vnd.rip":["rip"],"audio/x-aac":["aac"],"audio/x-aiff":["aif","aiff","aifc"],"audio/x-caf":["caf"],"audio/x-flac":["flac"],"audio/x-m4a":["*m4a"],"audio/x-matroska":["mka"],"audio/x-mpegurl":["m3u"],"audio/x-ms-wax":["wax"],"audio/x-ms-wma":["wma"],"audio/x-pn-realaudio":["ram","ra"],"audio/x-pn-realaudio-plugin":["rmp"],"audio/x-realaudio":["*ra"],"audio/x-wav":["*wav"],"chemical/x-cdx":["cdx"],"chemical/x-cif":["cif"],"chemical/x-cmdf":["cmdf"],"chemical/x-cml":["cml"],"chemical/x-csml":["csml"],"chemical/x-xyz":["xyz"],"image/prs.btif":["btif"],"image/prs.pti":["pti"],"image/vnd.adobe.photoshop":["psd"],"image/vnd.airzip.accelerator.azv":["azv"],"image/vnd.dece.graphic":["uvi","uvvi","uvg","uvvg"],"image/vnd.djvu":["djvu","djv"],"image/vnd.dvb.subtitle":["*sub"],"image/vnd.dwg":["dwg"],"image/vnd.dxf":["dxf"],"image/vnd.fastbidsheet":["fbs"],"image/vnd.fpx":["fpx"],"image/vnd.fst":["fst"],"image/vnd.fujixerox.edmics-mmr":["mmr"],"image/vnd.fujixerox.edmics-rlc":["rlc"],"image/vnd.microsoft.icon":["ico"],"image/vnd.ms-dds":["dds"],"image/vnd.ms-modi":["mdi"],"image/vnd.ms-photo":["wdp"],"image/vnd.net-fpx":["npx"],"image/vnd.tencent.tap":["tap"],"image/vnd.valve.source.texture":["vtf"],"image/vnd.wap.wbmp":["wbmp"],"image/vnd.xiff":["xif"],"image/vnd.zbrush.pcx":["pcx"],"image/x-3ds":["3ds"],"image/x-cmu-raster":["ras"],"image/x-cmx":["cmx"],"image/x-freehand":["fh","fhc","fh4","fh5","fh7"],"image/x-icon":["*ico"],"image/x-jng":["jng"],"image/x-mrsid-image":["sid"],"image/x-ms-bmp":["*bmp"],"image/x-pcx":["*pcx"],"image/x-pict":["pic","pct"],"image/x-portable-anymap":["pnm"],"image/x-portable-bitmap":["pbm"],"image/x-portable-graymap":["pgm"],"image/x-portable-pixmap":["ppm"],"image/x-rgb":["rgb"],"image/x-tga":["tga"],"image/x-xbitmap":["xbm"],"image/x-xpixmap":["xpm"],"image/x-xwindowdump":["xwd"],"message/vnd.wfa.wsc":["wsc"],"model/vnd.collada+xml":["dae"],"model/vnd.dwf":["dwf"],"model/vnd.gdl":["gdl"],"model/vnd.gtw":["gtw"],"model/vnd.mts":["mts"],"model/vnd.opengex":["ogex"],"model/vnd.parasolid.transmit.binary":["x_b"],"model/vnd.parasolid.transmit.text":["x_t"],"model/vnd.usdz+zip":["usdz"],"model/vnd.valve.source.compiled-map":["bsp"],"model/vnd.vtu":["vtu"],"text/prs.lines.tag":["dsc"],"text/vnd.curl":["curl"],"text/vnd.curl.dcurl":["dcurl"],"text/vnd.curl.mcurl":["mcurl"],"text/vnd.curl.scurl":["scurl"],"text/vnd.dvb.subtitle":["sub"],"text/vnd.fly":["fly"],"text/vnd.fmi.flexstor":["flx"],"text/vnd.graphviz":["gv"],"text/vnd.in3d.3dml":["3dml"],"text/vnd.in3d.spot":["spot"],"text/vnd.sun.j2me.app-descriptor":["jad"],"text/vnd.wap.wml":["wml"],"text/vnd.wap.wmlscript":["wmls"],"text/x-asm":["s","asm"],"text/x-c":["c","cc","cxx","cpp","h","hh","dic"],"text/x-component":["htc"],"text/x-fortran":["f","for","f77","f90"],"text/x-handlebars-template":["hbs"],"text/x-java-source":["java"],"text/x-lua":["lua"],"text/x-markdown":["mkd"],"text/x-nfo":["nfo"],"text/x-opml":["opml"],"text/x-org":["*org"],"text/x-pascal":["p","pas"],"text/x-processing":["pde"],"text/x-sass":["sass"],"text/x-scss":["scss"],"text/x-setext":["etx"],"text/x-sfv":["sfv"],"text/x-suse-ymp":["ymp"],"text/x-uuencode":["uu"],"text/x-vcalendar":["vcs"],"text/x-vcard":["vcf"],"video/vnd.dece.hd":["uvh","uvvh"],"video/vnd.dece.mobile":["uvm","uvvm"],"video/vnd.dece.pd":["uvp","uvvp"],"video/vnd.dece.sd":["uvs","uvvs"],"video/vnd.dece.video":["uvv","uvvv"],"video/vnd.dvb.file":["dvb"],"video/vnd.fvt":["fvt"],"video/vnd.mpegurl":["mxu","m4u"],"video/vnd.ms-playready.media.pyv":["pyv"],"video/vnd.uvvu.mp4":["uvu","uvvu"],"video/vnd.vivo":["viv"],"video/x-f4v":["f4v"],"video/x-fli":["fli"],"video/x-flv":["flv"],"video/x-m4v":["m4v"],"video/x-matroska":["mkv","mk3d","mks"],"video/x-mng":["mng"],"video/x-ms-asf":["asf","asx"],"video/x-ms-vob":["vob"],"video/x-ms-wm":["wm"],"video/x-ms-wmv":["wmv"],"video/x-ms-wmx":["wmx"],"video/x-ms-wvx":["wvx"],"video/x-msvideo":["avi"],"video/x-sgi-movie":["movie"],"video/x-smv":["smv"],"x-conference/x-cooltalk":["ice"]},mime=new Mime_1(standard,other),Visibility,FileType;function isReadableStream(e){return e instanceof Stream&&typeof("function"===e._read)&&typeof("object"===e._readableState)}!function(e){e.PUBLIC="public",e.PRIVATE="private"}(Visibility||(Visibility={})),function(e){e.file="file",e.dir="dir",e.link="link"}(FileType||(FileType={}));var isArray=Array.isArray,isArray_1=isArray,freeGlobal="object"==typeof commonjsGlobal&&commonjsGlobal&&commonjsGlobal.Object===Object&&commonjsGlobal,_freeGlobal=freeGlobal,freeSelf="object"==typeof self&&self&&self.Object===Object&&self,root=_freeGlobal||freeSelf||Function("return this")(),_root=root,Symbol$1=_root.Symbol,_Symbol=Symbol$1,objectProto=Object.prototype,hasOwnProperty=objectProto.hasOwnProperty,nativeObjectToString=objectProto.toString,symToStringTag=_Symbol?_Symbol.toStringTag:void 0;function getRawTag(e){var t=hasOwnProperty.call(e,symToStringTag),i=e[symToStringTag];try{e[symToStringTag]=void 0;var a=!0}catch(e){}var n=nativeObjectToString.call(e);return a&&(t?e[symToStringTag]=i:delete e[symToStringTag]),n}var _getRawTag=getRawTag,objectProto$1=Object.prototype,nativeObjectToString$1=objectProto$1.toString;function objectToString(e){return nativeObjectToString$1.call(e)}var _objectToString=objectToString,nullTag="[object Null]",undefinedTag="[object Undefined]",symToStringTag$1=_Symbol?_Symbol.toStringTag:void 0;function baseGetTag(e){return null==e?void 0===e?undefinedTag:nullTag:symToStringTag$1&&symToStringTag$1 in Object(e)?_getRawTag(e):_objectToString(e)}var _baseGetTag=baseGetTag;function isObjectLike(e){return null!=e&&"object"==typeof e}var isObjectLike_1=isObjectLike,symbolTag="[object Symbol]";function isSymbol(e){return"symbol"==typeof e||isObjectLike_1(e)&&_baseGetTag(e)==symbolTag}var isSymbol_1=isSymbol,reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey(e,t){if(isArray_1(e))return!1;var i=typeof e;return!("number"!=i&&"symbol"!=i&&"boolean"!=i&&null!=e&&!isSymbol_1(e))||(reIsPlainProp.test(e)||!reIsDeepProp.test(e)||null!=t&&e in Object(t))}var _isKey=isKey;function isObject(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)}var isObject_1=isObject,asyncTag="[object AsyncFunction]",funcTag="[object Function]",genTag="[object GeneratorFunction]",proxyTag="[object Proxy]";function isFunction(e){if(!isObject_1(e))return!1;var t=_baseGetTag(e);return t==funcTag||t==genTag||t==asyncTag||t==proxyTag}var isFunction_1=isFunction,coreJsData=_root["__core-js_shared__"],_coreJsData=coreJsData,maskSrcKey=(uid=/[^.]+$/.exec(_coreJsData&&_coreJsData.keys&&_coreJsData.keys.IE_PROTO||""),uid?"Symbol(src)_1."+uid:""),uid;function isMasked(e){return!!maskSrcKey&&maskSrcKey in e}var _isMasked=isMasked,funcProto=Function.prototype,funcToString=funcProto.toString;function toSource(e){if(null!=e){try{return funcToString.call(e)}catch(e){}try{return e+""}catch(e){}}return""}var _toSource=toSource,reRegExpChar=/[\\^$.*+?()[\]{}|]/g,reIsHostCtor=/^\[object .+?Constructor\]$/,funcProto$1=Function.prototype,objectProto$2=Object.prototype,funcToString$1=funcProto$1.toString,hasOwnProperty$1=objectProto$2.hasOwnProperty,reIsNative=RegExp("^"+funcToString$1.call(hasOwnProperty$1).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function baseIsNative(e){return!(!isObject_1(e)||_isMasked(e))&&(isFunction_1(e)?reIsNative:reIsHostCtor).test(_toSource(e))}var _baseIsNative=baseIsNative;function getValue(e,t){return null==e?void 0:e[t]}var _getValue=getValue;function getNative(e,t){var i=_getValue(e,t);return _baseIsNative(i)?i:void 0}var _getNative=getNative,nativeCreate=_getNative(Object,"create"),_nativeCreate=nativeCreate;function hashClear(){this.__data__=_nativeCreate?_nativeCreate(null):{},this.size=0}var _hashClear=hashClear;function hashDelete(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}var _hashDelete=hashDelete,HASH_UNDEFINED="__lodash_hash_undefined__",objectProto$3=Object.prototype,hasOwnProperty$2=objectProto$3.hasOwnProperty;function hashGet(e){var t=this.__data__;if(_nativeCreate){var i=t[e];return i===HASH_UNDEFINED?void 0:i}return hasOwnProperty$2.call(t,e)?t[e]:void 0}var _hashGet=hashGet,objectProto$4=Object.prototype,hasOwnProperty$3=objectProto$4.hasOwnProperty;function hashHas(e){var t=this.__data__;return _nativeCreate?void 0!==t[e]:hasOwnProperty$3.call(t,e)}var _hashHas=hashHas,HASH_UNDEFINED$1="__lodash_hash_undefined__";function hashSet(e,t){var i=this.__data__;return this.size+=this.has(e)?0:1,i[e]=_nativeCreate&&void 0===t?HASH_UNDEFINED$1:t,this}var _hashSet=hashSet;function Hash(e){var t=-1,i=null==e?0:e.length;for(this.clear();++t<i;){var a=e[t];this.set(a[0],a[1])}}Hash.prototype.clear=_hashClear,Hash.prototype.delete=_hashDelete,Hash.prototype.get=_hashGet,Hash.prototype.has=_hashHas,Hash.prototype.set=_hashSet;var _Hash=Hash;function listCacheClear(){this.__data__=[],this.size=0}var _listCacheClear=listCacheClear;function eq(e,t){return e===t||e!=e&&t!=t}var eq_1=eq;function assocIndexOf(e,t){for(var i=e.length;i--;)if(eq_1(e[i][0],t))return i;return-1}var _assocIndexOf=assocIndexOf,arrayProto=Array.prototype,splice=arrayProto.splice;function listCacheDelete(e){var t=this.__data__,i=_assocIndexOf(t,e);return!(i<0)&&(i==t.length-1?t.pop():splice.call(t,i,1),--this.size,!0)}var _listCacheDelete=listCacheDelete;function listCacheGet(e){var t=this.__data__,i=_assocIndexOf(t,e);return i<0?void 0:t[i][1]}var _listCacheGet=listCacheGet;function listCacheHas(e){return _assocIndexOf(this.__data__,e)>-1}var _listCacheHas=listCacheHas;function listCacheSet(e,t){var i=this.__data__,a=_assocIndexOf(i,e);return a<0?(++this.size,i.push([e,t])):i[a][1]=t,this}var _listCacheSet=listCacheSet;function ListCache(e){var t=-1,i=null==e?0:e.length;for(this.clear();++t<i;){var a=e[t];this.set(a[0],a[1])}}ListCache.prototype.clear=_listCacheClear,ListCache.prototype.delete=_listCacheDelete,ListCache.prototype.get=_listCacheGet,ListCache.prototype.has=_listCacheHas,ListCache.prototype.set=_listCacheSet;var _ListCache=ListCache,Map=_getNative(_root,"Map"),_Map=Map;function mapCacheClear(){this.size=0,this.__data__={hash:new _Hash,map:new(_Map||_ListCache),string:new _Hash}}var _mapCacheClear=mapCacheClear;function isKeyable(e){var t=typeof e;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==e:null===e}var _isKeyable=isKeyable;function getMapData(e,t){var i=e.__data__;return _isKeyable(t)?i["string"==typeof t?"string":"hash"]:i.map}var _getMapData=getMapData;function mapCacheDelete(e){var t=_getMapData(this,e).delete(e);return this.size-=t?1:0,t}var _mapCacheDelete=mapCacheDelete;function mapCacheGet(e){return _getMapData(this,e).get(e)}var _mapCacheGet=mapCacheGet;function mapCacheHas(e){return _getMapData(this,e).has(e)}var _mapCacheHas=mapCacheHas;function mapCacheSet(e,t){var i=_getMapData(this,e),a=i.size;return i.set(e,t),this.size+=i.size==a?0:1,this}var _mapCacheSet=mapCacheSet;function MapCache(e){var t=-1,i=null==e?0:e.length;for(this.clear();++t<i;){var a=e[t];this.set(a[0],a[1])}}MapCache.prototype.clear=_mapCacheClear,MapCache.prototype.delete=_mapCacheDelete,MapCache.prototype.get=_mapCacheGet,MapCache.prototype.has=_mapCacheHas,MapCache.prototype.set=_mapCacheSet;var _MapCache=MapCache,FUNC_ERROR_TEXT="Expected a function";function memoize(e,t){if("function"!=typeof e||null!=t&&"function"!=typeof t)throw new TypeError(FUNC_ERROR_TEXT);var i=function(){var a=arguments,n=t?t.apply(this,a):a[0],r=i.cache;if(r.has(n))return r.get(n);var o=e.apply(this,a);return i.cache=r.set(n,o)||r,o};return i.cache=new(memoize.Cache||_MapCache),i}memoize.Cache=_MapCache;var memoize_1=memoize,MAX_MEMOIZE_SIZE=500;function memoizeCapped(e){var t=memoize_1(e,(function(e){return i.size===MAX_MEMOIZE_SIZE&&i.clear(),e})),i=t.cache;return t}var _memoizeCapped=memoizeCapped,rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,reEscapeChar=/\\(\\)?/g,stringToPath=_memoizeCapped((function(e){var t=[];return 46===e.charCodeAt(0)&&t.push(""),e.replace(rePropName,(function(e,i,a,n){t.push(a?n.replace(reEscapeChar,"$1"):i||e)})),t})),_stringToPath=stringToPath;function arrayMap(e,t){for(var i=-1,a=null==e?0:e.length,n=Array(a);++i<a;)n[i]=t(e[i],i,e);return n}var _arrayMap=arrayMap,INFINITY=1/0,symbolProto=_Symbol?_Symbol.prototype:void 0,symbolToString=symbolProto?symbolProto.toString:void 0;function baseToString(e){if("string"==typeof e)return e;if(isArray_1(e))return _arrayMap(e,baseToString)+"";if(isSymbol_1(e))return symbolToString?symbolToString.call(e):"";var t=e+"";return"0"==t&&1/e==-INFINITY?"-0":t}var _baseToString=baseToString;function toString(e){return null==e?"":_baseToString(e)}var toString_1=toString;function castPath(e,t){return isArray_1(e)?e:_isKey(e,t)?[e]:_stringToPath(toString_1(e))}var _castPath=castPath,INFINITY$1=1/0;function toKey(e){if("string"==typeof e||isSymbol_1(e))return e;var t=e+"";return"0"==t&&1/e==-INFINITY$1?"-0":t}var _toKey=toKey;function baseGet(e,t){for(var i=0,a=(t=_castPath(t,e)).length;null!=e&&i<a;)e=e[_toKey(t[i++])];return i&&i==a?e:void 0}var _baseGet=baseGet;function get(e,t,i){var a=null==e?void 0:_baseGet(e,t);return void 0===a?i:a}var get_1=get,PathPrefixer=function(){function e(t,i){void 0===i&&(i="/"),this.separator=i,this.prefix=t.replace(e.rTrim,""),""!==t&&(this.prefix+=i)}return e.prototype.prefixPath=function(t){return this.prefix+t.replace(e.lTrim,"")},e.prototype.stripPrefix=function(e){return e.slice(this.prefix.length)},e.prototype.stripDirectoryPrefix=function(t){return this.stripPrefix(t).replace(e.rTrim,"")},e.prototype.prefixDirectoryPath=function(t){var i=this.prefixPath(t.replace(e.rTrim,""));return i.substr(-1)===this.separator||""===i?i:i+this.separator},e.lTrim=/^[\\/]+/,e.rTrim=/[\\/]+$/,e}();function bindErrorConstructor(e,t){Object.setPrototypeOf(e,t.prototype),Error.captureStackTrace&&Error.captureStackTrace(e,e.constructor),e.name=t.name}var FilesystemException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(Error),Exception=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(FilesystemException),FileExistsException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(Exception),FileNotFoundException=function(e){function t(i){var a,n="File not found at path: "+i;return bindErrorConstructor(a=e.call(this,n)||this,t),a}return __extends(t,e),t}(Exception),FileSystemNotFoundException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(Exception),InvalidRootException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(Error),UnReadableFileException=function(e){function t(i){var a=e.call(this,"Unreadable file encountered: "+i)||this;return a.path=i,bindErrorConstructor(a,t),a}return __extends(t,e),t}(Error),NotSupportedException=function(e){function t(i){var a=e.call(this,i)||this;return a.message=i,bindErrorConstructor(a,t),a}return __extends(t,e),t.forLink=function(e){return new t("Links are not supported, encountered link at "+e)},t}(Error),InvalidArgumentException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(FilesystemException),InvalidStreamProvidedException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t}(InvalidArgumentException),FilesystemOperationFailedException=function(e){function t(t){var i=e.call(this,t)||this;return bindErrorConstructor(i,FilesystemException),i}return __extends(t,e),t.OPERATION_WRITE="WRITE",t.OPERATION_UPDATE="UPDATE",t.OPERATION_FILE_EXISTS="FILE_EXISTS",t.OPERATION_CREATE_DIRECTORY="CREATE_DIRECTORY",t.OPERATION_DELETE="DELETE",t.OPERATION_DELETE_DIRECTORY="DELETE_DIRECTORY",t.OPERATION_MOVE="MOVE",t.OPERATION_RETRIEVE_METADATA="RETRIEVE_METADATA",t.OPERATION_COPY="COPY",t.OPERATION_READ="READ",t.OPERATION_SET_VISIBILITY="SET_VISIBILITY",t}(FilesystemException),UnableToReadFileException=function(e){function t(i){var a=e.call(this,i)||this;return a._location="",a._reason="",bindErrorConstructor(a,t),a}return __extends(t,e),t.fromLocation=function(e,i,a){void 0===i&&(i="");var n=new t(("Unable to read file from location: "+e+". {$reason}").trimEnd());return n._location=e,n._reason=i,n},t.prototype.reason=function(){return this._reason},t.prototype.location=function(){return this._location},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_READ},t}(FilesystemOperationFailedException),UnableToSetVisibilityException=function(e){function t(i){var a=e.call(this,i)||this;return a._location="",a._reason="",bindErrorConstructor(a,t),a}return __extends(t,e),t.atLocation=function(e,i,a){void 0===i&&(i="");var n=new t(("Unable to set visibility for file "+e+". "+i).trimEnd());return n._reason=i,n._location=e,n},t.prototype.reason=function(){return this._reason},t.prototype.location=function(){return this._location},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_SET_VISIBILITY},t}(FilesystemOperationFailedException),OPTION_VISIBILITY="visibility",OPTION_DIRECTORY_VISIBILITY="directory_visibility",ATTRIBUTE_PATH="path",ATTRIBUTE_TYPE="type",ATTRIBUTE_FILE_SIZE="file_size",ATTRIBUTE_VISIBILITY="visibility",ATTRIBUTE_LAST_MODIFIED="last_modified",ATTRIBUTE_MIME_TYPE="mime_type",ATTRIBUTE_EXTRA_METADATA="extra_metadata",UnableToRetrieveMetadataException=function(e){function t(i){var a=e.call(this,i)||this;return a._location="",a._metadataType="",a._reason="",bindErrorConstructor(a,t),a}return __extends(t,e),t.lastModified=function(e,t,i){return void 0===t&&(t=""),void 0===i&&(i=null),this.create(e,ATTRIBUTE_LAST_MODIFIED,t,i)},t.visibility=function(e,t,i){return void 0===t&&(t=""),void 0===i&&(i=null),this.create(e,ATTRIBUTE_VISIBILITY,t,i)},t.fileSize=function(e,t,i){return void 0===t&&(t=""),void 0===i&&(i=null),this.create(e,ATTRIBUTE_FILE_SIZE,t,i)},t.mimeType=function(e,t,i){return void 0===t&&(t=""),void 0===i&&(i=null),this.create(e,ATTRIBUTE_MIME_TYPE,t,i)},t.create=function(e,i,a,n){void 0===a&&(a="");var r=new t("Unable to retrieve the $type for file at location: "+e+". "+a);return r._reason=a,r._location=e,r._metadataType=i,r},t.prototype.reason=function(){return this._reason},t.prototype.location=function(){return this._location},t.prototype.metadataType=function(){return this._metadataType},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_RETRIEVE_METADATA},t}(FilesystemOperationFailedException),UnableToMoveFileException=function(e){function t(i){var a=e.call(this,i)||this;return a._source="",a._destination="",bindErrorConstructor(a,t),a}return __extends(t,e),t.prototype.source=function(){return this._source},t.prototype.destination=function(){return this._destination},t.fromLocationTo=function(e,i,a){var n=new t("Unable to move file from "+e+" to "+i);return n._source=e,n._destination=i,n},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_MOVE},t}(FilesystemOperationFailedException),SymbolicLinkEncounteredException=function(e){function t(i){var a=e.call(this,i)||this;return a._location="",bindErrorConstructor(a,t),a}return __extends(t,e),t.prototype.location=function(){return this._location},t.atLocation=function(e){var i=new t("Unsupported symbolic link encountered at location "+e);return i._location=e,i},t}(FilesystemException),UnableToCopyFileException=function(e){function t(i){var a=e.call(this,i)||this;return a._source="",a._destination="",bindErrorConstructor(a,t),a}return __extends(t,e),t.prototype.source=function(){return this._source},t.prototype.destination=function(){return this._destination},t.fromLocationTo=function(e,i,a){var n=new t("Unable to move file from "+e+" to "+i);return n._source=e,n._destination=i,n},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_COPY},t}(FilesystemOperationFailedException),UnableToCreateDirectoryException=function(e){function t(i){var a=e.call(this,i)||this;return bindErrorConstructor(a,t),a}return __extends(t,e),t.atLocation=function(e,i){void 0===i&&(i="");var a=new t(("Unable to create a directory at "+e+". "+i).trimEnd());return a.location=e,a},t}(Exception),UnableToDeleteFileException=function(e){function t(i){var a=e.call(this,i)||this;return a._location="",a._reason="",bindErrorConstructor(a,t),a}return __extends(t,e),t.atLocation=function(e,i,a){void 0===i&&(i=""),void 0===a&&(a="");var n=new t(('"Unable to delete file located at: {$location}. {$reason}": '+a).trimEnd());return n._location=e,n._reason=i,n},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_DELETE},t.prototype.reason=function(){return this._reason},t.prototype.location=function(){return this._location},t}(FilesystemOperationFailedException),UnableToWriteFileException=function(e){function t(i){var a=e.call(this,i)||this;return a._location="",a._reason="",bindErrorConstructor(a,t),a}return __extends(t,e),t.atLocation=function(e,i,a){void 0===i&&(i="");var n=new t(("Unable to write file at location: "+e+". "+i).trimEnd());return n._location=e,n._reason=i,n},t.prototype.operation=function(){return FilesystemOperationFailedException.OPERATION_WRITE},t.prototype.reason=function(){return this._reason},t.prototype.location=function(){return this._location},t}(FilesystemOperationFailedException),PathTraversalDetectedException=function(e){function t(i){var a=e.call(this,i)||this;return a._path="",bindErrorConstructor(a,t),a}return __extends(t,e),t.prototype.path=function(){return this._path},t.forPath=function(e){var i=new t("Path traversal detected: "+e);return i._path=e,i},t}(FilesystemException),objectProto$5=Object.prototype;function isPrototype(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||objectProto$5)}var _isPrototype=isPrototype;function overArg(e,t){return function(i){return e(t(i))}}var _overArg=overArg,nativeKeys=_overArg(Object.keys,Object),_nativeKeys=nativeKeys,objectProto$6=Object.prototype,hasOwnProperty$4=objectProto$6.hasOwnProperty;function baseKeys(e){if(!_isPrototype(e))return _nativeKeys(e);var t=[];for(var i in Object(e))hasOwnProperty$4.call(e,i)&&"constructor"!=i&&t.push(i);return t}var _baseKeys=baseKeys,DataView=_getNative(_root,"DataView"),_DataView=DataView,Promise$1=_getNative(_root,"Promise"),_Promise=Promise$1,Set$1=_getNative(_root,"Set"),_Set=Set$1,WeakMap=_getNative(_root,"WeakMap"),_WeakMap=WeakMap,mapTag="[object Map]",objectTag="[object Object]",promiseTag="[object Promise]",setTag="[object Set]",weakMapTag="[object WeakMap]",dataViewTag="[object DataView]",dataViewCtorString=_toSource(_DataView),mapCtorString=_toSource(_Map),promiseCtorString=_toSource(_Promise),setCtorString=_toSource(_Set),weakMapCtorString=_toSource(_WeakMap),getTag=_baseGetTag;(_DataView&&getTag(new _DataView(new ArrayBuffer(1)))!=dataViewTag||_Map&&getTag(new _Map)!=mapTag||_Promise&&getTag(_Promise.resolve())!=promiseTag||_Set&&getTag(new _Set)!=setTag||_WeakMap&&getTag(new _WeakMap)!=weakMapTag)&&(getTag=function(e){var t=_baseGetTag(e),i=t==objectTag?e.constructor:void 0,a=i?_toSource(i):"";if(a)switch(a){case dataViewCtorString:return dataViewTag;case mapCtorString:return mapTag;case promiseCtorString:return promiseTag;case setCtorString:return setTag;case weakMapCtorString:return weakMapTag}return t});var _getTag=getTag,argsTag="[object Arguments]";function baseIsArguments(e){return isObjectLike_1(e)&&_baseGetTag(e)==argsTag}var _baseIsArguments=baseIsArguments,objectProto$7=Object.prototype,hasOwnProperty$5=objectProto$7.hasOwnProperty,propertyIsEnumerable=objectProto$7.propertyIsEnumerable,isArguments=_baseIsArguments(function(){return arguments}())?_baseIsArguments:function(e){return isObjectLike_1(e)&&hasOwnProperty$5.call(e,"callee")&&!propertyIsEnumerable.call(e,"callee")},isArguments_1=isArguments,MAX_SAFE_INTEGER=9007199254740991;function isLength(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=MAX_SAFE_INTEGER}var isLength_1=isLength;function isArrayLike(e){return null!=e&&isLength_1(e.length)&&!isFunction_1(e)}var isArrayLike_1=isArrayLike;function stubFalse(){return!1}var stubFalse_1=stubFalse,isBuffer_1=createCommonjsModule((function(e,t){var i=t&&!t.nodeType&&t,a=i&&e&&!e.nodeType&&e,n=a&&a.exports===i?_root.Buffer:void 0,r=(n?n.isBuffer:void 0)||stubFalse_1;e.exports=r})),argsTag$1="[object Arguments]",arrayTag="[object Array]",boolTag="[object Boolean]",dateTag="[object Date]",errorTag="[object Error]",funcTag$1="[object Function]",mapTag$1="[object Map]",numberTag="[object Number]",objectTag$1="[object Object]",regexpTag="[object RegExp]",setTag$1="[object Set]",stringTag="[object String]",weakMapTag$1="[object WeakMap]",arrayBufferTag="[object ArrayBuffer]",dataViewTag$1="[object DataView]",float32Tag="[object Float32Array]",float64Tag="[object Float64Array]",int8Tag="[object Int8Array]",int16Tag="[object Int16Array]",int32Tag="[object Int32Array]",uint8Tag="[object Uint8Array]",uint8ClampedTag="[object Uint8ClampedArray]",uint16Tag="[object Uint16Array]",uint32Tag="[object Uint32Array]",typedArrayTags={};function baseIsTypedArray(e){return isObjectLike_1(e)&&isLength_1(e.length)&&!!typedArrayTags[_baseGetTag(e)]}typedArrayTags[float32Tag]=typedArrayTags[float64Tag]=typedArrayTags[int8Tag]=typedArrayTags[int16Tag]=typedArrayTags[int32Tag]=typedArrayTags[uint8Tag]=typedArrayTags[uint8ClampedTag]=typedArrayTags[uint16Tag]=typedArrayTags[uint32Tag]=!0,typedArrayTags[argsTag$1]=typedArrayTags[arrayTag]=typedArrayTags[arrayBufferTag]=typedArrayTags[boolTag]=typedArrayTags[dataViewTag$1]=typedArrayTags[dateTag]=typedArrayTags[errorTag]=typedArrayTags[funcTag$1]=typedArrayTags[mapTag$1]=typedArrayTags[numberTag]=typedArrayTags[objectTag$1]=typedArrayTags[regexpTag]=typedArrayTags[setTag$1]=typedArrayTags[stringTag]=typedArrayTags[weakMapTag$1]=!1;var _baseIsTypedArray=baseIsTypedArray;function baseUnary(e){return function(t){return e(t)}}var _baseUnary=baseUnary,_nodeUtil=createCommonjsModule((function(e,t){var i=t&&!t.nodeType&&t,a=i&&e&&!e.nodeType&&e,n=a&&a.exports===i&&_freeGlobal.process,r=function(){try{var e=a&&a.require&&a.require("util").types;return e||n&&n.binding&&n.binding("util")}catch(e){}}();e.exports=r})),nodeIsTypedArray=_nodeUtil&&_nodeUtil.isTypedArray,isTypedArray=nodeIsTypedArray?_baseUnary(nodeIsTypedArray):_baseIsTypedArray,isTypedArray_1=isTypedArray,mapTag$2="[object Map]",setTag$2="[object Set]",objectProto$8=Object.prototype,hasOwnProperty$6=objectProto$8.hasOwnProperty;function isEmpty(e){if(null==e)return!0;if(isArrayLike_1(e)&&(isArray_1(e)||"string"==typeof e||"function"==typeof e.splice||isBuffer_1(e)||isTypedArray_1(e)||isArguments_1(e)))return!e.length;var t=_getTag(e);if(t==mapTag$2||t==setTag$2)return!e.size;if(_isPrototype(e))return!_baseKeys(e).length;for(var i in e)if(hasOwnProperty$6.call(e,i))return!1;return!0}var isEmpty_1=isEmpty,WhitespacePathNormalizer=function(){function e(){}return e.prototype.removeFunkyWhiteSpace=function(e){for(var t=/\p{C}+|^\.\//u;t.test(e);)e=e.replace(t,"");return e},e.prototype.normalizeRelativePath=function(e){for(var t=[],i=0,a=e.split("/");i<a.length;i++){var n=a[i];switch(n){case"":case".":break;case"..":if(isEmpty_1(t))throw PathTraversalDetectedException.forPath(e);t.pop();break;default:t.push(n)}}return t.join("/")},e.prototype.normalizePath=function(e){return e=e.replace(/\\/g,"/"),e=this.removeFunkyWhiteSpace(e),this.normalizeRelativePath(e)},e}(),FInfoMimeTypeDetector=function(){function e(){}return e.prototype.detectMimeType=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a;return __generator(this,(function(n){switch(n.label){case 0:return t?[4,this.detectMimeTypeFromBuffer(t)]:[3,2];case 1:if(i=n.sent())return[2,i];n.label=2;case 2:return[4,this.detectMimeTypeFromFile(e)];case 3:return(a=n.sent())?[2,a]:[2,this.detectMimeTypeFromPath(e)]}}))}))},e.prototype.detectMimeTypeFromBuffer=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(i){switch(i.label){case 0:return e instanceof Stream?[4,fileType_1.fromStream(e)]:[3,2];case 1:return t=i.sent(),[3,4];case 2:return[4,fileType_1.fromBuffer(e)];case 3:t=i.sent(),i.label=4;case 4:return t?[2,t.mime]:[2]}}))}))},e.prototype.detectMimeTypeFromFile=function(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(i){switch(i.label){case 0:return[4,fileType_1.fromFile(e)];case 1:return(t=i.sent())?[2,t.mime]:[2]}}))}))},e.prototype.detectMimeTypeFromPath=function(e){var t=extname(e);if(t){var i=mime.getType(t);if(i)return i}},e}(),DirectoryAttributes=function(e,t,i){this.path=e,this.visibility=t,this.lastModified=i,this.isDir=!0,this.isFile=!1,this.type=FileType.file},FileAttributes=function(e,t,i,a,n,r){void 0===r&&(r={}),this.path=e,this.fileSize=t,this.visibility=i,this.lastModified=a,this.mimeType=n,this.extraMetadata=r,this.isDir=!1,this.isFile=!0,this.type=FileType.file},PortableVisibilityGuard=function(){function e(){}return e.guardAgainstInvalidInput=function(e){if(e!==Visibility.PUBLIC&&e!==Visibility.PRIVATE)throw new Error("Invalid visibility provided. Expected either Visibility.PUBLIC or Visibility.PUBLIC, received "+e)},e}(),PortableVisibilityConverter=function(){function e(e,t,i,a,n){void 0===e&&(e=420),void 0===t&&(t=384),void 0===i&&(i=493),void 0===a&&(a=448),void 0===n&&(n=Visibility.PRIVATE),this.filePublic=e,this.filePrivate=t,this.directoryPublic=i,this.directoryPrivate=a,this._defaultForDirectories=n}return e.prototype.defaultForDirectories=function(){return this._defaultForDirectories===Visibility.PUBLIC?this.directoryPublic:this.directoryPrivate},e.prototype.forDirectory=function(e){return PortableVisibilityGuard.guardAgainstInvalidInput(e),e===Visibility.PUBLIC?this.directoryPublic:this.directoryPrivate},e.prototype.forFile=function(e){return PortableVisibilityGuard.guardAgainstInvalidInput(e),e===Visibility.PUBLIC?this.filePublic:this.filePrivate},e.prototype.inverseForDirectory=function(e){return e===this.directoryPublic?Visibility.PUBLIC:e===this.directoryPrivate?Visibility.PRIVATE:Visibility.PUBLIC},e.prototype.inverseForFile=function(e){return e===this.filePublic?Visibility.PUBLIC:e===this.filePrivate?Visibility.PRIVATE:Visibility.PUBLIC},e.fromObject=function(t,i){var a,n,r,o;return void 0===i&&(i=Visibility.PRIVATE),new e(null===(a=t.file)||void 0===a?void 0:a.public,null===(n=t.file)||void 0===n?void 0:n.private,null===(r=t.dir)||void 0===r?void 0:r.public,null===(o=t.dir)||void 0===o?void 0:o.private,i)},e}(),Filesystem=function(){function e(e,t,i){void 0===t&&(t={}),void 0===i&&(i=new WhitespacePathNormalizer),this.adapter=e,this.config=t,this.pathNormalizer=i}return e.prototype.getAdapter=function(){return this.adapter},e.prototype.getConfig=function(e,t){return get_1(this.config,e,t)},e.prototype.fileExists=function(e){return this.adapter.fileExists(this.pathNormalizer.normalizePath(e))},e.prototype.write=function(e,t,i){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(a){return[2,this.getAdapter().write(this.pathNormalizer.normalizePath(e),t,i)]}))}))},e.prototype.writeStream=function(e,t,i){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(a){if(!isReadableStream(t))throw new InvalidStreamProvidedException("writeStream expects argument #2 to be a valid readStream.");return e=this.pathNormalizer.normalizePath(e),i=this.prepareConfig(i),[2,this.getAdapter().writeStream(e,t,i)]}))}))},e.prototype.read=function(e,t){return this.getAdapter().read(this.pathNormalizer.normalizePath(e),t)},e.prototype.readStream=function(e,t){return this.getAdapter().readStream(this.pathNormalizer.normalizePath(e),t)},e.prototype.copy=function(e,t,i){return this.getAdapter().copy(this.pathNormalizer.normalizePath(e),this.pathNormalizer.normalizePath(t),i)},e.prototype.delete=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){return[2,this.getAdapter().delete(this.pathNormalizer.normalizePath(e))]}))}))},e.prototype.deleteDirectory=function(e){return this.getAdapter().deleteDirectory(this.pathNormalizer.normalizePath(e))},e.prototype.createDirectory=function(e,t){return t=this.prepareConfig(t),this.getAdapter().createDirectory(this.pathNormalizer.normalizePath(e),this.prepareConfig(t))},e.prototype.listContents=function(t,i){return void 0===t&&(t=""),void 0===i&&(i=e.LIST_DEEP),__awaiter(this,void 0,void 0,(function(){return __generator(this,(function(e){return[2,this.getAdapter().listContents(this.pathNormalizer.normalizePath(t),i)]}))}))},e.prototype.mimeType=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getAdapter().mimeType(this.pathNormalizer.normalizePath(e))];case 1:return[2,t.sent().mimeType]}}))}))},e.prototype.lastModified=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getAdapter().lastModified(this.pathNormalizer.normalizePath(e))];case 1:return[2,t.sent().lastModified]}}))}))},e.prototype.visibility=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getAdapter().visibility(this.pathNormalizer.normalizePath(e))];case 1:return[2,t.sent().visibility]}}))}))},e.prototype.fileSize=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return[4,this.getAdapter().fileSize(this.pathNormalizer.normalizePath(e))];case 1:return[2,t.sent().fileSize]}}))}))},e.prototype.setVisibility=function(e,t){return this.getAdapter().setVisibility(this.pathNormalizer.normalizePath(e),t)},e.prototype.move=function(e,t,i){return this.getAdapter().move(this.pathNormalizer.normalizePath(e),this.pathNormalizer.normalizePath(t),this.prepareConfig(i))},e.prototype.prepareConfig=function(e){return e},e.adapter=function(e,t){return e||t?(e&&t&&(this._adapter[e]=t),e&&!t?this._adapter[e]:void 0):this._adapter},e.LIST_SHALLOW=!1,e.LIST_DEEP=!0,e._adapter={},e}(),MAX_SAFE_INTEGER$1=9007199254740991,nativeFloor=Math.floor;function baseRepeat(e,t){var i="";if(!e||t<1||t>MAX_SAFE_INTEGER$1)return i;do{t%2&&(i+=e),(t=nativeFloor(t/2))&&(e+=e)}while(t);return i}var _baseRepeat=baseRepeat;function baseSlice(e,t,i){var a=-1,n=e.length;t<0&&(t=-t>n?0:n+t),(i=i>n?n:i)<0&&(i+=n),n=t>i?0:i-t>>>0,t>>>=0;for(var r=Array(n);++a<n;)r[a]=e[a+t];return r}var _baseSlice=baseSlice;function castSlice(e,t,i){var a=e.length;return i=void 0===i?a:i,!t&&i>=a?e:_baseSlice(e,t,i)}var _castSlice=castSlice,rsAstralRange="\\ud800-\\udfff",rsComboMarksRange="\\u0300-\\u036f",reComboHalfMarksRange="\\ufe20-\\ufe2f",rsComboSymbolsRange="\\u20d0-\\u20ff",rsComboRange=rsComboMarksRange+reComboHalfMarksRange+rsComboSymbolsRange,rsVarRange="\\ufe0e\\ufe0f",rsZWJ="\\u200d",reHasUnicode=RegExp("["+rsZWJ+rsAstralRange+rsComboRange+rsVarRange+"]");function hasUnicode(e){return reHasUnicode.test(e)}var _hasUnicode=hasUnicode;function baseProperty(e){return function(t){return null==t?void 0:t[e]}}var _baseProperty=baseProperty,asciiSize=_baseProperty("length"),_asciiSize=asciiSize,rsAstralRange$1="\\ud800-\\udfff",rsComboMarksRange$1="\\u0300-\\u036f",reComboHalfMarksRange$1="\\ufe20-\\ufe2f",rsComboSymbolsRange$1="\\u20d0-\\u20ff",rsComboRange$1=rsComboMarksRange$1+reComboHalfMarksRange$1+rsComboSymbolsRange$1,rsVarRange$1="\\ufe0e\\ufe0f",rsAstral="["+rsAstralRange$1+"]",rsCombo="["+rsComboRange$1+"]",rsFitz="\\ud83c[\\udffb-\\udfff]",rsModifier="(?:"+rsCombo+"|"+rsFitz+")",rsNonAstral="[^"+rsAstralRange$1+"]",rsRegional="(?:\\ud83c[\\udde6-\\uddff]){2}",rsSurrPair="[\\ud800-\\udbff][\\udc00-\\udfff]",rsZWJ$1="\\u200d",reOptMod=rsModifier+"?",rsOptVar="["+rsVarRange$1+"]?",rsOptJoin="(?:"+rsZWJ$1+"(?:"+[rsNonAstral,rsRegional,rsSurrPair].join("|")+")"+rsOptVar+reOptMod+")*",rsSeq=rsOptVar+reOptMod+rsOptJoin,rsSymbol="(?:"+[rsNonAstral+rsCombo+"?",rsCombo,rsRegional,rsSurrPair,rsAstral].join("|")+")",reUnicode=RegExp(rsFitz+"(?="+rsFitz+")|"+rsSymbol+rsSeq,"g");function unicodeSize(e){for(var t=reUnicode.lastIndex=0;reUnicode.test(e);)++t;return t}var _unicodeSize=unicodeSize;function stringSize(e){return _hasUnicode(e)?_unicodeSize(e):_asciiSize(e)}var _stringSize=stringSize;function asciiToArray(e){return e.split("")}var _asciiToArray=asciiToArray,rsAstralRange$2="\\ud800-\\udfff",rsComboMarksRange$2="\\u0300-\\u036f",reComboHalfMarksRange$2="\\ufe20-\\ufe2f",rsComboSymbolsRange$2="\\u20d0-\\u20ff",rsComboRange$2=rsComboMarksRange$2+reComboHalfMarksRange$2+rsComboSymbolsRange$2,rsVarRange$2="\\ufe0e\\ufe0f",rsAstral$1="["+rsAstralRange$2+"]",rsCombo$1="["+rsComboRange$2+"]",rsFitz$1="\\ud83c[\\udffb-\\udfff]",rsModifier$1="(?:"+rsCombo$1+"|"+rsFitz$1+")",rsNonAstral$1="[^"+rsAstralRange$2+"]",rsRegional$1="(?:\\ud83c[\\udde6-\\uddff]){2}",rsSurrPair$1="[\\ud800-\\udbff][\\udc00-\\udfff]",rsZWJ$2="\\u200d",reOptMod$1=rsModifier$1+"?",rsOptVar$1="["+rsVarRange$2+"]?",rsOptJoin$1="(?:"+rsZWJ$2+"(?:"+[rsNonAstral$1,rsRegional$1,rsSurrPair$1].join("|")+")"+rsOptVar$1+reOptMod$1+")*",rsSeq$1=rsOptVar$1+reOptMod$1+rsOptJoin$1,rsSymbol$1="(?:"+[rsNonAstral$1+rsCombo$1+"?",rsCombo$1,rsRegional$1,rsSurrPair$1,rsAstral$1].join("|")+")",reUnicode$1=RegExp(rsFitz$1+"(?="+rsFitz$1+")|"+rsSymbol$1+rsSeq$1,"g");function unicodeToArray(e){return e.match(reUnicode$1)||[]}var _unicodeToArray=unicodeToArray;function stringToArray(e){return _hasUnicode(e)?_unicodeToArray(e):_asciiToArray(e)}var _stringToArray=stringToArray,nativeCeil=Math.ceil;function createPadding(e,t){var i=(t=void 0===t?" ":_baseToString(t)).length;if(i<2)return i?_baseRepeat(t,e):t;var a=_baseRepeat(t,nativeCeil(e/_stringSize(t)));return _hasUnicode(t)?_castSlice(_stringToArray(a),0,e).join(""):a.slice(0,e)}var _createPadding=createPadding,NAN=NaN,reTrim=/^\s+|\s+$/g,reIsBadHex=/^[-+]0x[0-9a-f]+$/i,reIsBinary=/^0b[01]+$/i,reIsOctal=/^0o[0-7]+$/i,freeParseInt=parseInt;function toNumber(e){if("number"==typeof e)return e;if(isSymbol_1(e))return NAN;if(isObject_1(e)){var t="function"==typeof e.valueOf?e.valueOf():e;e=isObject_1(t)?t+"":t}if("string"!=typeof e)return 0===e?e:+e;e=e.replace(reTrim,"");var i=reIsBinary.test(e);return i||reIsOctal.test(e)?freeParseInt(e.slice(2),i?2:8):reIsBadHex.test(e)?NAN:+e}var toNumber_1=toNumber,INFINITY$2=1/0,MAX_INTEGER=17976931348623157e292;function toFinite(e){return e?(e=toNumber_1(e))===INFINITY$2||e===-INFINITY$2?(e<0?-1:1)*MAX_INTEGER:e==e?e:0:0===e?e:0}var toFinite_1=toFinite;function toInteger(e){var t=toFinite_1(e),i=t%1;return t==t?i?t-i:t:0}var toInteger_1=toInteger;function padStart(e,t,i){e=toString_1(e);var a=(t=toInteger_1(t))?_stringSize(e):0;return t&&a<t?_createPadding(t-a,i)+e:e}var padStart_1=padStart,chmod=promisify(chmod$1),access=promisify(access$1),lstat=promisify(lstat$1),mkdir=promisify(mkdir$1),readdir=promisify(readdir$1),rmdir=promisify(rmdir$1),stat=promisify(stat$1),unlink=promisify(unlink$1),copyFile=promisify(copyFile$1),readFile=promisify(readFile$1),writeFile=promisify(writeFile$1),rename=promisify(rename$1),realpath=promisify(realpath$1),symlink=promisify(symlink$1);function pathExists(e){return access(e).then((function(){return!0})).catch((function(){return!1}))}function isDir(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return t.trys.push([0,2,,3]),[4,lstat(e)];case 1:return[2,t.sent().isDirectory()];case 2:return t.sent(),[3,3];case 3:return[2,!1]}}))}))}function isFile(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return t.trys.push([0,2,,3]),[4,lstat(e)];case 1:return[2,t.sent().isFile()];case 2:return t.sent(),[3,3];case 3:return[2,!1]}}))}))}function isReadable(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return t.trys.push([0,2,,3]),[4,access(e,constants.R_OK)];case 1:return t.sent(),[2,!0];case 2:return t.sent(),[2,!1];case 3:return[2]}}))}))}function mkDir(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a,n,r,o,s;return __generator(this,(function(p){switch(p.label){case 0:void 0===t&&(t=511^process.umask()),i=[],a=[],n=e,p.label=1;case 1:p.label=2;case 2:return p.trys.push([2,4,,5]),[4,stat(n)];case 3:if(p.sent().isDirectory())return[3,6];throw new Error("Unable to create directory at "+n);case 4:if("ENOENT"!==(r=p.sent()).code)throw r;return a.push(n),n=dirname(n),[3,5];case 5:return[3,1];case 6:o=a.length-1,p.label=7;case 7:return o>-1?(s=a[o],[4,mkdir(s,t)]):[3,10];case 8:p.sent(),i.push(s),p.label=9;case 9:return o--,[3,7];case 10:return[2,i]}}))}))}function getRecursiveDirectoryIterator(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a,n,r,o,s,p;return __generator(this,(function(c){switch(c.label){case 0:return[4,readdir(e)];case 1:return t=c.sent(),[4,Promise.all(t.map((function(t){var i=join(e,t);return lstat(i).then((function(e){return{stats:e,path:i}}))})))];case 2:i=c.sent(),a=0,n=i,c.label=3;case 3:return a<n.length?(r=n[a]).stats.isDirectory()?(s=(o=i.push).apply,p=[i],[4,getRecursiveDirectoryIterator(r.path)]):[3,5]:[3,6];case 4:s.apply(o,p.concat([c.sent()])),c.label=5;case 5:return a++,[3,3];case 6:return[2,i]}}))}))}function getDirectoryIterator(e){return __awaiter(this,void 0,void 0,(function(){var t;return __generator(this,(function(i){switch(i.label){case 0:return[4,readdir(e)];case 1:return t=i.sent(),[2,Promise.all(t.map((function(t){var i=join(e,t);return lstat(i).then((function(e){return{stats:e,path:i}}))})))]}}))}))}function rmDir(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a,n,r;return __generator(this,(function(o){switch(o.label){case 0:return[4,readdir(e)];case 1:t=o.sent(),i=0,a=t,o.label=2;case 2:return i<a.length?(n=a[i],r=join(e,n),[4,lstat(r)]):[3,8];case 3:return o.sent().isDirectory()?[4,rmDir(r)]:[3,5];case 4:return o.sent(),[3,7];case 5:return[4,unlink(r)];case 6:o.sent(),o.label=7;case 7:return i++,[3,2];case 8:return[4,rmdir(e)];case 9:return o.sent(),[2,!0]}}))}))}function isDirSync(e){try{return statSync(e).isDirectory()}catch(e){return!1}}function mkDirSync(e,t,i){void 0===t&&(t=511^process.umask());for(var a=[],n=[],r=e;;)try{if(statSync(r).isDirectory())break;throw new Error("Unable to create directory at "+r)}catch(e){if("ENOENT"!==e.code)throw e;n.push(r),r=dirname(r)}for(var o=n.length-1;o>-1;o--){var s=n[o];mkdirSync(s,t),a.push(s)}return a}function defer(){var e,t;return{promise:new Promise((function(i,a){e=i,t=a})),resolve:e,reject:t}}var LocalFilesystemAdapter=function(){function e(t,i,a,n,r){void 0===i&&(i=new PortableVisibilityConverter),void 0===a&&(a="w"),void 0===n&&(n=e.DISALLOW_LINKS),void 0===r&&(r=new FInfoMimeTypeDetector),this._visibility=i,this.writeFlags=a,this.linkHandling=n,this.mimeTypeDetector=r,this.pathSeparator=sep,this.prefixer=new PathPrefixer(t,sep),this.ensureDirectorySync(t,this._visibility.defaultForDirectories())}return e.prototype.getPathPrefix=function(){return this.prefixer},e.prototype.fileExists=function(e){return isFile(this.prefixer.prefixPath(e))},e.prototype.ensureDirectorySync=function(e,t){if(!isDirSync(e)){var i=void 0;try{mkDirSync(e,t)}catch(e){i=e}if(!isDirSync(e)){var a=(null==i?void 0:i.message)||"";throw UnableToCreateDirectoryException.atLocation(e,a)}}},e.prototype.ensureDirectoryExists=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a,n;return __generator(this,(function(r){switch(r.label){case 0:return[4,isDir(e)];case 1:if(r.sent())return[3,7];i=void 0,r.label=2;case 2:return r.trys.push([2,4,,5]),[4,mkDir(e,t)];case 3:return r.sent(),[3,5];case 4:return a=r.sent(),i=a,[3,5];case 5:return[4,isDir(e)];case 6:if(!r.sent())throw n=(null==i?void 0:i.message)||"",UnableToCreateDirectoryException.atLocation(e,n);r.label=7;case 7:return[2]}}))}))},e.prototype.resolveDirectoryVisibility=function(e){return e?this._visibility.forDirectory(e):this._visibility.defaultForDirectories()},e.prototype.write=function(e,t,i){return void 0===i&&(i={visibility:Visibility.PUBLIC}),__awaiter(this,void 0,void 0,(function(){var a,n,r,o,s;return __generator(this,(function(p){switch(p.label){case 0:return a=this.prefixer.prefixPath(e),[4,this.ensureDirectoryExists(dirname(a),this.resolveDirectoryVisibility(i[OPTION_DIRECTORY_VISIBILITY]))];case 1:p.sent(),n=i[OPTION_VISIBILITY]||Visibility.PUBLIC,r={flag:(null==i?void 0:i.flag)||this.writeFlags,mode:this._visibility.forFile(n)},i.encoding&&(r.encoding=i.encoding),p.label=2;case 2:return p.trys.push([2,8,,9]),(o=r.mode)?[4,this.fileExists(e)]:[3,4];case 3:o=p.sent(),p.label=4;case 4:return o?[4,this.setPermissions(a,r.mode)]:[3,6];case 5:p.sent(),p.label=6;case 6:return[4,writeFile(a,t,r)];case 7:return p.sent(),[3,9];case 8:throw s=p.sent(),UnableToWriteFileException.atLocation(e,s.message,s);case 9:return[2]}}))}))},e.prototype.writeStream=function(e,t,i){return void 0===i&&(i={visibility:Visibility.PUBLIC}),__awaiter(this,void 0,void 0,(function(){var a,n,r,o,s;return __generator(this,(function(p){switch(p.label){case 0:return a=this.prefixer.prefixPath(e),[4,this.ensureDirectoryExists(dirname(a),this.resolveDirectoryVisibility(i[OPTION_DIRECTORY_VISIBILITY]))];case 1:return p.sent(),n=i[OPTION_VISIBILITY]||Visibility.PUBLIC,r={flags:(null==i?void 0:i.flag)||this.writeFlags,mode:this._visibility.forFile(n)},(null==i?void 0:i.encoding)&&(r.encoding=i.encoding),o=defer(),s=createWriteStream(a,r),t.pipe(s),s.once("finish",(function(){o.resolve()})),s.once("error",(function(e){o.reject(UnableToWriteFileException.atLocation(a,e.message,e))})),[2,o.promise]}}))}))},e.prototype.readStream=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a,n;return __generator(this,(function(r){return i=this.prefixer.prefixPath(e),a=createReadStream(i,t),n=defer(),a.once("error",(function(t){n.reject(UnableToReadFileException.fromLocation(e,t.message,t))})),a.once("ready",(function(){n.resolve(a)})),[2,n.promise]}))}))},e.prototype.read=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a;return __generator(this,(function(n){switch(n.label){case 0:i=this.prefixer.prefixPath(e),n.label=1;case 1:return n.trys.push([1,3,,4]),[4,readFile(i,t)];case 2:return[2,n.sent()];case 3:throw a=n.sent(),UnableToReadFileException.fromLocation(e,a.message,a);case 4:return[2]}}))}))},e.prototype.move=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a,n,r;return __generator(this,(function(o){switch(o.label){case 0:return i=this.prefixer.prefixPath(e),a=this.prefixer.prefixPath(t),n=this.prefixer.prefixPath(dirname(t)),[4,this.ensureDirectoryExists(n)];case 1:o.sent(),o.label=2;case 2:return o.trys.push([2,4,,5]),[4,rename(i,a)];case 3:return o.sent(),[3,5];case 4:throw r=o.sent(),UnableToMoveFileException.fromLocationTo(e,t,r);case 5:return[2]}}))}))},e.prototype.copy=function(e,t,i){return __awaiter(this,void 0,void 0,(function(){var a,n,r;return __generator(this,(function(o){switch(o.label){case 0:return a=this.prefixer.prefixPath(e),n=this.prefixer.prefixPath(t),[4,this.ensureDirectoryExists(dirname(n),this.resolveDirectoryVisibility(i?i[OPTION_DIRECTORY_VISIBILITY]:void 0))];case 1:o.sent(),o.label=2;case 2:return o.trys.push([2,4,,5]),[4,copyFile(a,n)];case 3:return o.sent(),[3,5];case 4:throw r=o.sent(),UnableToCopyFileException.fromLocationTo(a,n,r);case 5:return[2]}}))}))},e.prototype.delete=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i;return __generator(this,(function(a){switch(a.label){case 0:return[4,pathExists(t=this.prefixer.prefixPath(e))];case 1:if(!a.sent())return[2];a.label=2;case 2:return a.trys.push([2,4,,5]),[4,unlink(t)];case 3:return a.sent(),[3,5];case 4:throw i=a.sent(),UnableToDeleteFileException.atLocation(e,i.message);case 5:return[2]}}))}))},e.prototype.listContents=function(t,i){return void 0===t&&(t=""),void 0===i&&(i=!1),__awaiter(this,void 0,void 0,(function(){var a,n,r,o,s,p,c,l;return __generator(this,(function(m){switch(m.label){case 0:return a=[],[4,isDir(n=this.prefixer.prefixPath(t))];case 1:return m.sent()?i?[4,getRecursiveDirectoryIterator(n)]:[3,3]:[2,[]];case 2:return r=m.sent(),[3,5];case 3:return[4,getDirectoryIterator(n)];case 4:r=m.sent(),m.label=5;case 5:for(o=0,s=r;o<s.length;o++){if((p=s[o]).stats.isSymbolicLink()){if(this.linkHandling&e.SKIP_LINKS)continue;throw SymbolicLinkEncounteredException.atLocation(p.path)}c=this.getFilePath(p),/(^|\/|\\)\.{1,2}$/.test(c)||(l=this.normalizeFileInfo(p))&&a.push(l)}return[2,a]}}))}))},e.prototype.fileSize=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a,n;return __generator(this,(function(r){switch(r.label){case 0:t=this.prefixer.prefixPath(e),r.label=1;case 1:return r.trys.push([1,3,,4]),[4,stat(t)];case 2:return i=r.sent(),[3,4];case 3:return n=r.sent(),a=n,[3,4];case 4:if(i&&i.isFile())return[2,new FileAttributes(e,i.size)];throw UnableToRetrieveMetadataException.fileSize(e,null==a?void 0:a.message,a)}}))}))},e.prototype.lastModified=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a;return __generator(this,(function(n){switch(n.label){case 0:t=this.prefixer.prefixPath(e),n.label=1;case 1:return n.trys.push([1,3,,4]),[4,stat(t)];case 2:return i=n.sent(),[2,new FileAttributes(e,void 0,void 0,i.ctimeMs)];case 3:throw a=n.sent(),UnableToRetrieveMetadataException.lastModified(e,a.message);case 4:return[2]}}))}))},e.prototype.mimeType=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a,n;return __generator(this,(function(r){switch(r.label){case 0:t=this.prefixer.prefixPath(e),r.label=1;case 1:return r.trys.push([1,3,,4]),[4,this.mimeTypeDetector.detectMimeType(t)];case 2:return i=r.sent(),[3,4];case 3:return n=r.sent(),a=n,[3,4];case 4:if(!i||a)throw UnableToRetrieveMetadataException.mimeType(e,null==a?void 0:a.message,a);return[2,new FileAttributes(e,void 0,void 0,void 0,i)]}}))}))},e.prototype.visibility=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a,n,r,o;return __generator(this,(function(s){switch(s.label){case 0:t=this.prefixer.prefixPath(e),s.label=1;case 1:return s.trys.push([1,3,,4]),[4,lstat(t)];case 2:return a=s.sent(),i=a.mode,[3,4];case 3:throw n=s.sent(),UnableToRetrieveMetadataException.create(e,n.message,n);case 4:return r=parseInt(padStart_1((1023&i).toString(8),4,"0"),8),o=this._visibility.inverseForFile(r),[2,new FileAttributes(e,void 0,o)]}}))}))},e.prototype.setVisibility=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i,a;return __generator(this,(function(n){switch(n.label){case 0:return[4,isDir(i=this.prefixer.prefixPath(e))];case 1:return a=n.sent()?this._visibility.forDirectory(t):this._visibility.forFile(t),[4,this.setPermissions(i,a)];case 2:return n.sent(),[2]}}))}))},e.prototype.createDirectory=function(e,t){return void 0===t&&(t={visibility:Visibility.PUBLIC}),__awaiter(this,void 0,void 0,(function(){var i,a,n,r;return __generator(this,(function(o){switch(o.label){case 0:return i=this.prefixer.prefixPath(e),a=t[OPTION_DIRECTORY_VISIBILITY]||t[OPTION_VISIBILITY]||Visibility.PUBLIC,n=this.resolveDirectoryVisibility(a),[4,isDir(i)];case 1:return o.sent()?[4,this.setPermissions(i,n)]:[3,3];case 2:return o.sent(),[2];case 3:return o.trys.push([3,5,,6]),[4,mkDir(i,n)];case 4:return o.sent(),[3,6];case 5:throw r=o.sent(),UnableToCreateDirectoryException.atLocation(i,r.message);case 6:return[2]}}))}))},e.prototype.deleteDirectory=function(e){return __awaiter(this,void 0,void 0,(function(){var t,i,a,n,r;return __generator(this,(function(o){switch(o.label){case 0:return[4,isDir(t=this.prefixer.prefixPath(e))];case 1:return o.sent()?[4,getRecursiveDirectoryIterator(t)]:[2];case 2:i=o.sent(),a=0,n=i,o.label=3;case 3:return a<n.length?(r=n[a],[4,this.guardAgainstUnreadableFileInfo(r)]):[3,6];case 4:o.sent(),o.label=5;case 5:return a++,[3,3];case 6:return[2,rmDir(t).then((function(){}))]}}))}))},e.prototype.normalizeFileInfo=function(t){if(!t.stats.isSymbolicLink())return this.mapFileInfo(t);if(this.linkHandling&e.DISALLOW_LINKS)throw NotSupportedException.forLink(t.path)},e.prototype.getFilePath=function(e){var t=e.path;return this.prefixer.stripPrefix(t).replace(/\\/g,"/").replace(/^\/|\/$/,"")},e.prototype.mapFileInfo=function(e){var t=this.prefixer.stripPrefix(e.path);return e.stats.isFile()?new FileAttributes(this.prefixer.stripPrefix(e.path),e.stats.size,this._visibility.inverseForFile(e.stats.mode),e.stats.ctimeMs,void 0,{}):new DirectoryAttributes(t,this._visibility.inverseForDirectory(e.stats.mode),e.stats.ctimeMs)},e.prototype.guardAgainstUnreadableFileInfo=function(e){return __awaiter(this,void 0,void 0,(function(){return __generator(this,(function(t){switch(t.label){case 0:return[4,isReadable(e.path)];case 1:if(!t.sent())throw new UnReadableFileException(e.path);return[2]}}))}))},e.prototype.setPermissions=function(e,t){return __awaiter(this,void 0,void 0,(function(){var i;return __generator(this,(function(a){switch(a.label){case 0:return a.trys.push([0,2,,3]),[4,chmod(e,t)];case 1:return a.sent(),[3,3];case 2:throw i=a.sent(),UnableToSetVisibilityException.atLocation(this.prefixer.stripPrefix(e),i.message,i);case 3:return[2]}}))}))},e.SKIP_LINKS=1,e.DISALLOW_LINKS=2,e}();Filesystem.adapter("local",LocalFilesystemAdapter);export{ATTRIBUTE_EXTRA_METADATA,ATTRIBUTE_FILE_SIZE,ATTRIBUTE_LAST_MODIFIED,ATTRIBUTE_MIME_TYPE,ATTRIBUTE_PATH,ATTRIBUTE_TYPE,ATTRIBUTE_VISIBILITY,DirectoryAttributes,Exception,FInfoMimeTypeDetector,FileAttributes,FileExistsException,FileNotFoundException,FileSystemNotFoundException,FileType,Filesystem,FilesystemException,InvalidArgumentException,InvalidRootException,InvalidStreamProvidedException,LocalFilesystemAdapter,NotSupportedException,OPTION_DIRECTORY_VISIBILITY,OPTION_VISIBILITY,PathPrefixer,PathTraversalDetectedException,PortableVisibilityConverter,PortableVisibilityGuard,SymbolicLinkEncounteredException,UnReadableFileException,UnableToCopyFileException,UnableToCreateDirectoryException,UnableToDeleteFileException,UnableToMoveFileException,UnableToReadFileException,UnableToRetrieveMetadataException,UnableToSetVisibilityException,UnableToWriteFileException,Visibility,WhitespacePathNormalizer};
//# sourceMappingURL=index.esm.browser.min.js.map
