/// <reference types="node" />
import { Visibility } from './enum';
import { IFilesystemOperator, IFilesystemConfig, IFilesystemAdapter } from './interfaces';
import { WhitespacePathNormalizer } from './libs';
import { Readable } from 'stream';
import { Type } from '@nestjs/common';
/**
 * filesystem manager
 */
export declare class Filesystem<T extends IFilesystemAdapter> implements IFilesystemOperator {
    protected adapter: T;
    protected config: IFilesystemConfig;
    protected pathNormalizer: WhitespacePathNormalizer;
    static LIST_SHALLOW: boolean;
    static LIST_DEEP: boolean;
    /**
     * adapter map
     * @private
     */
    private static _adapter;
    constructor(adapter: T, config?: IFilesystemConfig, pathNormalizer?: WhitespacePathNormalizer);
    /**
     * Get the Adapter.
     *
     * @return AdapterInterface adapter
     */
    getAdapter(): T;
    /**
     * get default config
     * @param key
     * @param defaultValue
     */
    protected getConfig(key: keyof IFilesystemConfig, defaultValue?: any): any;
    fileExists(location: string): Promise<boolean>;
    /**
     * @inheritdoc
     */
    write(path: string, contents: string | Buffer, config?: any): Promise<void>;
    /**
     * @inheritdoc
     */
    writeStream(path: string, resource: Readable, config?: Record<string, any>): Promise<void>;
    /**
     * @inheritdoc
     */
    read(path: string, config?: any): Promise<string | Buffer>;
    /**
     * @inheritdoc
     */
    readStream(path: string, config?: any): Promise<import("fs").ReadStream>;
    /**
     * @inheritdoc
     */
    copy(path: string, newPath: string, config?: any): Promise<void>;
    /**
     * @inheritdoc
     */
    delete(path: string): Promise<void>;
    /**
     * @inheritdoc
     */
    deleteDirectory(dirname: string): Promise<void>;
    /**
     * @inheritdoc
     */
    createDirectory(dirname: string, config?: any): Promise<void>;
    /**
     * @inheritdoc
     */
    listContents(directory?: string, recursive?: boolean): Promise<import("./interfaces").IStorageAttributes[]>;
    /**
     * @inheritdoc
     */
    mimeType(path: string): Promise<string>;
    /**
     * @inheritdoc
     */
    lastModified(path: string): Promise<number>;
    /**
     * @inheritdoc
     */
    visibility(path: string): Promise<Visibility>;
    /**
     * @inheritdoc
     */
    fileSize(path: string): Promise<number>;
    /**
     * @inheritdoc
     */
    setVisibility(path: string, visibility: Visibility | string): Promise<void>;
    /**
     * @inheritdoc
     */
    move(source: string, destination: string, config?: Record<string, any>): Promise<void>;
    protected prepareConfig(config?: any): any;
    static adapter(): {
        [s: string]: Type<IFilesystemAdapter>;
    };
    static adapter(name: string): Type<IFilesystemAdapter> | void;
    static adapter(name: string, adapter: Type<IFilesystemAdapter>): void;
}
