export declare class Funciones {
    constructor();
    /**
     * Rellena los espacios a la izquierda de la longitud deseada con la cadena
     * de rellono enviada
     *
     * @author Eder Ruíz
     * @fecha 09/09/2022
     *
     * @param cadenaOriginal string original
     * @param cadenaRelleno string de rellena
     * @param longitud numero de veces que se repetirá la cadena relleno
     * @returns cadena final
     */
    static LPAD(cadenaOriginal: string, cadenaRelleno: string, longitud: number): Promise<string>;
    /**
     * Función que redondea un calculo
     *
     * <b>Autor: </b> Aldair Cruz
     * <b>Fecha de Creación: </b> 12/03/2022
     *
     * @param {double} importe importe que será redondeado
     * @param {int} decimales Limite de Decimales a las cuales se redondeara
     * @returns regresa el impoorte redondeado
     */
    static round(importe: number, decimales: number): number;
    static totalCampo(array: any[], key: string, redondeo_decimales: number): number;
    /**
     * Convierte el Numero Recibido en un formato de moneda
     *
     * @param {double} importe
     */
    static getMoneda(importe: number): string;
    /**
     * Convierte el Numero Recibido en un formato de porcentaje
     *
     * @param {double} importe
     * @return retornara el importe en formato porcentaje <br>
     * ej. si importe es 1000 retornara $ 1,000.00 ej. si importe es 3.14151618
     * retornara 3.14%
     */
    static getPorcentaje(importe: number): string;
    /**
     * Devuelve una copia profunda de cualquier tipo de objeto o dato.
     * @param {any} objeto
     * @returns
     */
    static copiaProfunda(objeto: any): unknown;
}
