/**
 * Los método en la clase se van a referenciar a datos de tipo moment,
 * lo que nos refereimos a esto, es al paquete moment disponible en npm
 */
export declare class Fecha {
    /**
     *  Convierte una fecha de formato String a una fecha tipo moment
     *
     *  <b>Autor: </b> Aldair Cruz
     *  <b>Fecha de Creación: </b> 12/03/2022
     *
     * @param {string} fecha Se pasa la cadena de la fecha Ej: '2022-01-02'
     * @param {string} formato Se pasa el formato que se desea aplicar
     * @returns Regresa la fecha convertida a tipo moment con el formato deseado
     */
    static StoDate(fecha: string, formato: string): any;
    /**
     * Obtiene la diferencia en dias entre 2 fechas especificas
     *
     * <b>Autor: </b> Aldair Cruz
     * <b>Fecha de Creación: </b> 12/03/2022
     *
     * @param {string} fecha_inicial Se pasa la fecha inicial
     * @param {string} fecha_final Se pasa la fecha final
     * @returns regresa la diferencia en dias entre la fecha inicial y la fecha final
     */
    static diferenciaDias(fecha_inicial: string, fecha_final: string): any;
    /**
     * Obtiene la diferencia en meses entre 2 fechas especificas
     *
     * <b>Autor: </b> Aldair Cruz
     * <b>Fecha de Creación: </b> 12/03/2022
     *
     * @param {string} fecha_inicial Se pasa la fecha inicial
     * @param {string} fecha_final Se pasa la fecha final
     * @returns regresa la diferencia en meses entre la fecha inicial y la fecha final
     */
    static diferenciaMes(fecha_inicial: string, fecha_final: string): any;
    /**
     * Obtiene la diferencia en años entre 2 fechas especificas
     *
     * <b>Autor: </b> Aldair Cruz
     * <b>Fecha de Creación: </b> 12/03/2022
     *
     * @param {string} fecha_inicial Se pasa la fecha inicial
     * @param {string} fecha_final Se pasa la fecha final
     * @returns regresa la diferencia en años entre la fecha inicial y la fecha final
     */
    static diferenciaAnios(fecha_inicial: string, fecha_final: string): any;
    /**
     * Obtiene el día de la fecha proporcionada
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @returns
     */
    static getDayOfMonth(fecha: string): number;
    /**
     * Obtiene el año de la fecha proporcionada
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @returns
     */
    static getYear(fecha: string): number;
    /**
     * Obtiene el ultimo dia del mes que se le pase
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @returns
     */
    static getUltimoDiaMes(fecha: string): any;
    /**
     * Obtiene el dia que se le pase del mes y año proporcionado
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @param {int} dia
     * @returns
     */
    static withDayOfMonth(fecha: string, dia: number): any;
    /**
     * Se le suma a la fecha proporcionada el número de meses deseado
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @param {int} numero_meses
     * @returns
     */
    static plusMonths(fecha: string, numero_meses: number): any;
    static minusMonths(fecha: string, numero_meses: number): any;
    /**
     * Se le suma a la fecha proporcionada la cantidad de dias deseados
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @param {int} numero_dias
     * @returns
     */
    static plusDays(fecha: string, numero_dias: number): any;
    static minusDays(fecha: string, numero_dias: number): any;
    static plusYears(fecha: string, numero_anios: number): any;
    static minusYears(fecha: string, numero_anios: number): any;
    static lengthOfMonth(fecha: string): any;
    /**
     * Obtiene el Dia de la Semana
     *
     * @param {string} fecha
     * @returns
     */
    static getDayOfWeek(fecha: string): any;
    /**
     * Método estandar por el cual se pasa para poder realizar la suma de dia, mes, etc
     * a la fecha deseada
     *
     * @author Aldair Cruz
     *
     * @param {string} fecha
     * @param {int} numero
     * @param {string} tipo
     * @returns
     */
    static plusDate(fecha: string, numero: number, tipo: string): any;
    static minusDate(fecha: string, numero: number, tipo: string): any;
}
