class Funciones {
    /**
     * Función que redondea un calculo
     * 
     * <b>Autor: </b> Aldair Cruz
     * <b>Fecha de Creación: </b> 12/03/2022
     * 
     * @param {double} importe importe que será redondeado
     * @param {int} decimales Limite de Decimales a las cuales se redondeara
     * @returns regresa el impoorte redondeado
     */
    static round(importe, decimales) {
        importe = Number(importe);
        return Number(importe.toFixed(decimales));
    }

    static totalCampo(array, key, redondeo_decimales) {
        return Funciones.round(array.map(item => item[key]).reduce((valor_anterior, valor_actual) => valor_anterior + valor_actual, 0), redondeo_decimales);
    }

    /**
     * Convierte el Numero Recibido en un formato de moneda
     * 
     * @param {double} importe 
     */
    static getMoneda(importe) {
        return new Intl.NumberFormat('en-US', { style: 'currency', currency: 'MXN', minimumFractionDigits: 2 })
            .format(importe)
            .replace('MX', '');
    }

    /**
     * Convierte el Numero Recibido en un formato de porcentaje
     * 
     * @param {double} importe 
     * @return retornara el importe en formato porcentaje <br>
     * ej. si importe es 1000 retornara $ 1,000.00 ej. si importe es 3.14151618
     * retornara 3.14%
     */
    static getPorcentaje(importe) {
        return new Intl.NumberFormat('en-US', {
            style: 'percent',
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
        }).format(importe);
    }
}

module.exports = {
    Funciones
}