let crypto = require('crypto');
const { response } = require('express');

/**
 * Código para realizar la encriptación en AES 'AES/CBC/PKCS5PADDING' 
 * keyBase - Valor Original (KEY = 'Una cadena, muy, muy larga para ')
 * ivBase64 .- Valor Original (IV_KEY = 'znNoPM/MlY9zcoO2aQSU2g==')
 */
let keyBase64 = "VW5hIGNhZGVuYSwgbXV5LCBtdXkgbGFyZ2EgcGFyYSA=";
let ivBase64 = 'znNoPM/MlY9zcoO2aQSU2g==';

const getAlgorithm = (keyBase64) => {

    let key = Buffer.from(keyBase64, 'base64');
    switch (key.length) {
        case 16:
            return 'aes-128-cbc';
        case 32:
            return 'aes-256-cbc';

    }

    throw new Error('Invalid key length: ' + key.length);
}

const encrypt = (plainText) => {

    const key = Buffer.from(keyBase64, 'base64');
    const iv = Buffer.from(ivBase64, 'base64');

    const cipher = crypto.createCipheriv(getAlgorithm(keyBase64), key, iv.slice(0, 16));
    let encrypted = cipher.update(plainText, 'utf8', 'base64');
    encrypted += cipher.final('base64');
    return encrypted;
}

const decrypt = (messagebase64, req, res = response) => {

    try {
        const key = Buffer.from(keyBase64, 'base64');
        const iv = Buffer.from(ivBase64, 'base64');

        const decipher = crypto.createDecipheriv(getAlgorithm(keyBase64), key, iv.slice(0, 16));
        let decrypted = decipher.update(messagebase64, 'base64');

        decrypted += decipher.final();

        return decrypted;
    } catch (error) {
        return res.status(401).json({
            estatus: 401,
            errors: `Detalle al tratar de realizar la encriptación de '${messagebase64}'`
        });
    }
}

module.exports = {
    encrypt,
    decrypt
}

/**
 * Código comentado para descomentar y hacer pruebas
 */
// let plainText = '';

// let cipherText          = encrypt(plainText);
// let decryptedCipherText = decrypt(cipherText);

// console.log('Plaintext: ' + plainText);
// console.log('Ciphertext: ' + cipherText);
// console.log('Decoded Ciphertext: ' + decryptedCipherText);