const { response } = require('express');
const { validationResult } = require('express-validator');

const validarCampos = (req, res, next) => {
    const errores = validationResult(req);
    if (!errores.isEmpty()) {
        return res.status(400).json({
            estatus: 400,
            errors: errores.mapped()
        });
    }

    next();
}

validarParametros = function(body, parametros, callback) {
    
    let parametros_faltantes = [];
    parametros.forEach(function(parametro) {

        if(body['' + parametro] == undefined) {
            parametros_faltantes.push(parametro);
        }

    });
    
    if(parametros_faltantes == '') {
        callback(null, true);
    } else {
        callback(parametros_faltantes, null);
    }
}

module.exports = {
    validarCampos,
    validarParametros
}